/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GradientAlignment {
    top{

        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max(imageHeight - gradientHeight, 0);
        }

        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return 0;
        }
    }
    ,
    middle{

        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max((imageHeight - gradientHeight) / 2, 0);
        }

        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return this.getBottomRectangleHeight(imageHeight, gradientHeight);
        }
    }
    ,
    bottom{

        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return 0;
        }

        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max(imageHeight - gradientHeight, 0);
        }
    };


    public static final GradientAlignment getByParameter(String string) {
        if (string == null || string.length() == 0) {
            return middle;
        }
        return GradientAlignment.valueOf(string.toLowerCase(Locale.US));
    }

    public abstract int getTopRectangleHeight(int var1, int var2);

    public abstract int getBottomRectangleHeight(int var1, int var2);
}

