/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import javax.el.ValueExpression;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.el.util.ELUtils;
import org.richfaces.resource.ResourceMappingConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceMappingFeature {
    Packed(CoreConfiguration.Items.resourceMappingPackedStages),
    Compressed(CoreConfiguration.Items.resourceMappingCompressedStages);

    private static final String STATIC_RESOURCES_FEATURE_NAME = "Static";
    private static final String FEATURES_PLACEHOLDER = "%Features%";
    private static final String DEFAULT_LOCATION = "#{facesContext.externalContext.requestContextPath}/org.richfaces.resources/javax.faces.resource/org.richfaces.staticResource/#{a4j.version.implementationVersion}/%Features%/#{resourceLocation}";
    private static final String DEFAULT_MAPPING_FILE = "META-INF/richfaces/staticResourceMapping/%Features%.properties";
    private CoreConfiguration.Items associatedConfiguration;

    private ResourceMappingFeature(CoreConfiguration.Items associatedConfiguration) {
        this.associatedConfiguration = associatedConfiguration;
    }

    public static String getMappingFile() {
        ResourceMappingFeature.validateStaticResourceServingEnabled();
        String mappingFile = ResourceMappingConfiguration.getResourceMappingFile();
        if (mappingFile == null || "".equals(mappingFile)) {
            mappingFile = DEFAULT_MAPPING_FILE;
        }
        return ResourceMappingFeature.format(mappingFile, ResourceMappingFeature.getEnabledFeatures());
    }

    public static String getLocation() {
        ResourceMappingFeature.validateStaticResourceServingEnabled();
        ValueExpression mappingLocationExpression = ELUtils.createValueExpression((String)ResourceMappingFeature.getLocationAsExpression());
        return mappingLocationExpression.getValue(FacesContext.getCurrentInstance().getELContext()).toString();
    }

    private static String getLocationAsExpression() {
        String location = ResourceMappingConfiguration.getLocation();
        if (location == null) {
            location = DEFAULT_LOCATION;
        }
        return ResourceMappingFeature.format(location, ResourceMappingFeature.getEnabledFeatures());
    }

    private boolean isEnabled() {
        String configuredPhases = ResourceMappingConfiguration.getConfiguration(this.associatedConfiguration);
        if (configuredPhases == null) {
            return false;
        }
        ProjectStage projectStage = FacesContext.getCurrentInstance().getApplication().getProjectStage();
        return "All".equals(configuredPhases) || configuredPhases.matches("(^|.*,)" + projectStage.toString() + "($|,.*)");
    }

    private static void validateStaticResourceServingEnabled() {
        if (!ResourceMappingConfiguration.isEnabled()) {
            throw new IllegalStateException("Static resource serving needs to be enabled first to use static resources");
        }
    }

    private static String getEnabledFeatures() {
        StringBuffer affix = new StringBuffer();
        for (ResourceMappingFeature feature : ResourceMappingFeature.values()) {
            if (!feature.isEnabled()) continue;
            affix.append(feature.toString());
        }
        if (affix.length() == 0) {
            return STATIC_RESOURCES_FEATURE_NAME;
        }
        return affix.toString();
    }

    private static String format(String string, String message) {
        return string.replace(FEATURES_PLACEHOLDER, message);
    }
}

