package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.NotifyMessageRendererBase;
import static org.richfaces.renderkit.NotifyRendererUtils.addStackIdOption;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;


@ResourceDependencies({@ResourceDependency(name="notifyMessage.reslib",library="org.richfaces",target=""),@ResourceDependency(name="notify.ecss",library="org.richfaces",target="")})
public class HtmlNotifyMessagesRenderer extends NotifyMessageRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES84 = attributes()
	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeypress","onkeypress","keypress")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("style","style")
	     

	     .generic("title","title")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH62 = attributes()
	     .generic("sticky","sticky")
	     .defaultValue(false)

	     .generic("stayTime","stayTime")
	     

	     .generic("delay","delay")
	     

	     .generic("styleClass","styleClass")
	     

	     .generic("appearAnimation","appearAnimation")
	     

	     .generic("hideAnimation","hideAnimation")
	     

	     .generic("animationSpeed","animationSpeed")
	     

	     .generic("showHistory","showHistory")
	     .defaultValue(false)

	     .generic("nonblocking","nonblocking")
	     .defaultValue(false)

	     .generic("showShadow","showShadow")
	     .defaultValue(false)

	     .generic("showCloseButton","showCloseButton")
	     .defaultValue(true)

	     .generic("nonblockingOpacity","nonblockingOpacity")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
   {
      String value = "rf-ntf-msgs " + convertToString(component.getAttributes().get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES84);

Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH62, null);

addStackIdOption(options, facesContext, component);
encodeScript(facesContext,component, options);
encodeNotification(facesContext, component, options);
responseWriter.endElement("span"); 

	}
}

