package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import static org.richfaces.renderkit.NotifyRendererUtils.addStackIdOption;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.renderkit.html.NotifyRendererBase;


public class NotifyRenderer extends NotifyRendererBase {
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH63 = attributes()
	     .generic("summary","summary")
	     

	     .generic("detail","detail")
	     

	     .generic("position","position")
	     

	     .generic("sticky","sticky")
	     .defaultValue(false)

	     .generic("stayTime","stayTime")
	     

	     .generic("delay","delay")
	     

	     .generic("styleClass","styleClass")
	     

	     .generic("appearAnimation","appearAnimation")
	     

	     .generic("hideAnimation","hideAnimation")
	     

	     .generic("animationSpeed","animationSpeed")
	     

	     .generic("showHistory","showHistory")
	     .defaultValue(false)

	     .generic("nonblocking","nonblocking")
	     .defaultValue(false)

	     .generic("showShadow","showShadow")
	     .defaultValue(false)

	     .generic("showCloseButton","showCloseButton")
	     .defaultValue(true)

	     .generic("nonblockingOpacity","nonblockingOpacity")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
  responseWriter.writeAttribute("class","rf-ntf-span",null);

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH63, null);

addStackIdOption(options, facesContext, component);
{
	Object text = "RichFaces.ui.Notify(" + convertToString(toScriptArgs(options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("span"); 

	}
}

