/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServicesFactory;

public final class ServiceTracker {
    private static final Map<ClassLoader, ServicesFactory> INSTANCES = new ConcurrentHashMap<ClassLoader, ServicesFactory>();

    private ServiceTracker() {
    }

    public static <T> T getService(Class<T> target) {
        return ServiceTracker.getServicesFactory().getInstance(target);
    }

    public static <T> T getService(FacesContext context, Class<T> target) {
        return ServiceTracker.getServicesFactory().getInstance(target);
    }

    private static ServicesFactory getServicesFactory() {
        if (!INSTANCES.containsKey(ServiceTracker.getCurrentLoader())) {
            throw new FacesException("Service Tracker has not been initialized");
        }
        ServicesFactory service = INSTANCES.get(ServiceTracker.getCurrentLoader());
        return service;
    }

    private static ClassLoader getCurrentLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (null == contextClassLoader) {
            contextClassLoader = ServiceTracker.class.getClassLoader();
        }
        return contextClassLoader;
    }

    public static void setFactory(ServicesFactory factory) {
        INSTANCES.put(ServiceTracker.getCurrentLoader(), factory);
    }

    public static void release() {
        ServicesFactory servicesFactory = INSTANCES.remove(ServiceTracker.getCurrentLoader());
        servicesFactory.release();
    }
}

