/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.google.common.base.Function;

public final class ResourceKey {
    public static final Function<String, ResourceKey> FACTORY = new Function<String, ResourceKey>(){

        public ResourceKey apply(String from) {
            return ResourceKey.create(from);
        }
    };
    private final String resourceName;
    private final String libraryName;

    public ResourceKey(String resourceName, String libraryName) {
        this.resourceName = resourceName;
        this.libraryName = libraryName;
    }

    public static ResourceKey create(String resourceQualifier) {
        return new ResourceKey(ResourceKey.extractResourceName(resourceQualifier), ResourceKey.extractLibraryName(resourceQualifier));
    }

    public static ResourceKey create(String resourceName, String libraryName) {
        return new ResourceKey(resourceName, libraryName);
    }

    private static String extractResourceName(String resourceQualifier) {
        int idx = resourceQualifier.lastIndexOf(58);
        if (idx < 0) {
            return resourceQualifier;
        }
        return resourceQualifier.substring(idx + 1);
    }

    private static String extractLibraryName(String resourceQualifier) {
        int idx = resourceQualifier.lastIndexOf(58);
        if (idx < 0) {
            return null;
        }
        return resourceQualifier.substring(0, idx);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.libraryName == null ? 0 : this.libraryName.hashCode());
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceKey other = (ResourceKey)obj;
        if (this.libraryName == null ? other.libraryName != null && !"".equals(other.libraryName) : !this.libraryName.equals(other.libraryName) && (!"".equals(this.libraryName) || other.libraryName != null)) {
            return false;
        }
        return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
    }

    public String toString() {
        return this.libraryName + ":" + this.resourceName;
    }
}

