/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.richfaces.component.AbstractSelectManyComponent;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.component.util.SelectItemsInterface;
import org.richfaces.renderkit.ClientSelectItem;
import org.richfaces.renderkit.SelectHelper;
import org.richfaces.renderkit.SelectManyRendererBase;
import org.richfaces.renderkit.util.HtmlDimensions;

public class SelectManyHelper {
    public static final String CELL_CSS = "-c";
    public static final String ITEM_CSS = "-opt";
    public static final String ITEM_CSS_DIS = "-opt-dis";
    public static final String BUTTON_CSS = "-btn";
    public static final String BUTTON_CSS_DIS = "-btn-dis";
    public static Comparator<ClientSelectItem> clientSelectItemComparator = new Comparator<ClientSelectItem>(){

        @Override
        public int compare(ClientSelectItem clientSelectItem, ClientSelectItem clientSelectItem1) {
            Integer sortOrder = clientSelectItem == null || clientSelectItem.getSortOrder() == null ? 0 : clientSelectItem.getSortOrder();
            Integer sortOrder1 = clientSelectItem1 == null || clientSelectItem1.getSortOrder() == null ? 0 : clientSelectItem1.getSortOrder();
            return sortOrder.compareTo(sortOrder1);
        }
    };
    public static Predicate<ClientSelectItem> SELECTED_PREDICATE = new Predicate<ClientSelectItem>(){

        public boolean apply(@Nullable ClientSelectItem clientSelectItem) {
            return clientSelectItem.isSelected();
        }
    };
    public static Predicate<ClientSelectItem> UNSELECTED_PREDICATE = Predicates.not(SELECTED_PREDICATE);

    public static void encodeHeader(FacesContext facesContext, UIComponent component, SelectManyRendererBase renderer, String rowClass, String cellClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        Iterator<UIColumn> headers = select.columns();
        if (headers.hasNext()) {
            writer.startElement("tr", component);
            StringBuilder headerClass = new StringBuilder(rowClass);
            if (select.getHeaderClass() != null && !select.getHeaderClass().isEmpty()) {
                if (headerClass.length() > 0) {
                    headerClass.append(" ");
                }
                headerClass.append(select.getHeaderClass());
            }
            writer.writeAttribute("class", (Object)headerClass, null);
            while (headers.hasNext()) {
                UIColumn header = headers.next();
                writer.startElement("th", component);
                writer.writeAttribute("class", (Object)cellClass, null);
                UIComponent facet = header.getFacet("header");
                if (facet != null && facet.isRendered()) {
                    facet.encodeBegin(facesContext);
                    if (facet.getRendersChildren()) {
                        facet.encodeChildren(facesContext);
                    } else {
                        renderer.renderChildren(facesContext, facet);
                    }
                    facet.encodeEnd(facesContext);
                }
                writer.endElement("th");
            }
            writer.endElement("tr");
        }
    }

    public static void encodeRows(FacesContext facesContext, UIComponent component, SelectManyRendererBase renderer, Iterator<ClientSelectItem> clientSelectItems, String cssPrefix) throws IOException {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        if (clientSelectItems != null && clientSelectItems.hasNext()) {
            String clientId = component.getClientId(facesContext);
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            Object oldVar = requestMap.get(select.getVar());
            while (clientSelectItems.hasNext()) {
                ClientSelectItem clientSelectItem = clientSelectItems.next();
                requestMap.put(select.getVar(), clientSelectItem.getSelectItem().getValue());
                SelectManyHelper.encodeOneRow(facesContext, component, renderer, clientSelectItem, cssPrefix);
            }
            requestMap.put(select.getVar(), oldVar);
            oldVar = null;
        }
    }

    public static void encodeOneRow(FacesContext facesContext, UIComponent component, SelectManyRendererBase renderer, ClientSelectItem clientSelectItem, String cssPrefix) throws IOException {
        AbstractSelectManyComponent table = (AbstractSelectManyComponent)component;
        String defaultItemCss = cssPrefix + ITEM_CSS;
        String defaultItemCssDis = cssPrefix + ITEM_CSS_DIS;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = table.getClientId(facesContext);
        String itemClientId = clientId + "Item" + clientSelectItem.getSortOrder();
        clientSelectItem.setClientId(itemClientId);
        writer.startElement("tr", (UIComponent)table);
        writer.writeAttribute("id", (Object)itemClientId, null);
        String itemCss = !table.isDisabled() ? HtmlUtil.concatClasses(table.getItemClass(), defaultItemCss) : HtmlUtil.concatClasses(table.getItemClass(), defaultItemCss, defaultItemCssDis);
        writer.writeAttribute("class", (Object)itemCss, null);
        String cellClassName = cssPrefix + CELL_CSS;
        String[] columnClasses = table.getColumnClasses() != null ? table.getColumnClasses().split(",") : new String[]{};
        int columnCounter = 0;
        Iterator<UIColumn> columnIterator = table.columns();
        while (columnIterator.hasNext()) {
            UIColumn column = columnIterator.next();
            if (!column.isRendered()) continue;
            writer.startElement("td", (UIComponent)table);
            Object width = column.getAttributes().get("width");
            if (width != null) {
                writer.writeAttribute("style", (Object)("width: " + HtmlDimensions.formatSize((String)width.toString())), null);
            }
            String columnClass = columnClasses.length > 0 ? HtmlUtil.concatClasses(cellClassName, columnClasses[columnCounter % columnClasses.length], column.getAttributes().get("styleClass")) : HtmlUtil.concatClasses(cellClassName, column.getAttributes().get("styleClass"));
            writer.writeAttribute("class", (Object)columnClass, null);
            renderer.renderChildren(facesContext, (UIComponent)column);
            writer.endElement("td");
            ++columnCounter;
        }
        writer.endElement("tr");
    }

    public static void encodeItems(FacesContext facesContext, UIComponent component, Iterator<ClientSelectItem> clientSelectItems, String cssPrefix) throws IOException {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        String defaultItemCss = cssPrefix + ITEM_CSS;
        String defaultItemCssDis = cssPrefix + ITEM_CSS_DIS;
        if (clientSelectItems != null && clientSelectItems.hasNext()) {
            ResponseWriter writer = facesContext.getResponseWriter();
            String clientId = component.getClientId(facesContext);
            while (clientSelectItems.hasNext()) {
                ClientSelectItem clientSelectItem = clientSelectItems.next();
                String itemClientId = clientId + "Item" + clientSelectItem.getSortOrder();
                clientSelectItem.setClientId(itemClientId);
                writer.startElement("div", component);
                writer.writeAttribute("id", (Object)itemClientId, null);
                String itemCss = !select.isDisabled() ? HtmlUtil.concatClasses(select.getItemClass(), defaultItemCss) : HtmlUtil.concatClasses(select.getItemClass(), defaultItemCss, defaultItemCssDis);
                writer.writeAttribute("class", (Object)itemCss, null);
                String label = clientSelectItem.getLabel();
                if (label != null && label.trim().length() > 0) {
                    writer.writeText((Object)label, null);
                } else {
                    writer.write("\u00a0");
                }
                writer.endElement("div");
                writer.write(10);
            }
        }
    }

    public static List<ClientSelectItem> getClientSelectItems(FacesContext facesContext, AbstractSelectManyComponent select, Iterator<SelectItem> selectItems) {
        List<Object> values;
        ArrayList<ClientSelectItem> clientSelectItems = new ArrayList<ClientSelectItem>();
        Object object = select.getValue();
        if (object == null) {
            values = new ArrayList();
        } else if (object instanceof List) {
            values = (List)object;
        } else if (object instanceof Object[]) {
            values = Arrays.asList((Object[])object);
        } else {
            throw new IllegalArgumentException("Value expression must evaluate to either a List or Object[]");
        }
        HashSet valuesSet = new HashSet(values);
        int count = valuesSet.size();
        while (selectItems.hasNext()) {
            int sortOrder;
            boolean selected;
            SelectItem selectItem = selectItems.next();
            if (valuesSet.contains(selectItem.getValue())) {
                selected = true;
                sortOrder = values.indexOf(selectItem.getValue());
            } else {
                selected = false;
                sortOrder = count;
            }
            ClientSelectItem clientSelectItem = SelectHelper.generateClientSelectItem(facesContext, (UIComponent)select, selectItem, sortOrder, selected);
            clientSelectItems.add(clientSelectItem);
            if (selected) continue;
            ++count;
        }
        Collections.sort(clientSelectItems, clientSelectItemComparator);
        return clientSelectItems;
    }

    public static Object getConvertedValue(FacesContext facesContext, UIComponent component, Object val) throws ConverterException {
        String[] values = val == null ? new String[]{} : (String[])val;
        Converter converter = SelectManyHelper.getItemConverter(facesContext, component);
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null) {
            Class modelType = ve.getType(facesContext.getELContext());
            if (modelType.isArray()) {
                Object targetForConvertedValues = Array.newInstance(modelType, values.length);
                for (int i = 0; i < values.length; ++i) {
                    ((Object[])targetForConvertedValues)[i] = converter != null ? converter.getAsObject(facesContext, component, values[i]) : values[i];
                }
                return targetForConvertedValues;
            }
            if (Collection.class.isAssignableFrom(modelType)) {
                Collection<Object> targetForConvertedValues;
                String collectionType = (String)component.getAttributes().get("collectionType");
                if (collectionType != null) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = SelectManyRendererBase.class.getClassLoader();
                    }
                    try {
                        targetForConvertedValues = classLoader.loadClass(collectionType).asSubclass(Collection.class).newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new FacesException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new FacesException((Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new FacesException((Throwable)e);
                    }
                } else {
                    Collection value = (Collection)((EditableValueHolder)component).getValue();
                    if (value instanceof Cloneable) {
                        try {
                            targetForConvertedValues = (Collection)value.getClass().getMethod("clone", new Class[0]).invoke((Object)value, new Object[0]);
                            targetForConvertedValues.clear();
                        }
                        catch (IllegalAccessException e) {
                            throw new FacesException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new FacesException((Throwable)e);
                        }
                        catch (NoSuchMethodException e) {
                            throw new FacesException((Throwable)e);
                        }
                    } else {
                        targetForConvertedValues = SortedSet.class.isAssignableFrom(modelType) ? new TreeSet() : (Queue.class.isAssignableFrom(modelType) ? new LinkedList() : (Set.class.isAssignableFrom(modelType) ? new HashSet(values.length) : new ArrayList(values.length)));
                    }
                    for (int i = 0; i < values.length; ++i) {
                        if (converter != null) {
                            targetForConvertedValues.add(converter.getAsObject(facesContext, component, values[i]));
                            continue;
                        }
                        targetForConvertedValues.add(values[i]);
                    }
                }
                return targetForConvertedValues;
            }
            throw new FacesException(String.format("ModelType (%s) must be either an Array, or a Collection", modelType));
        }
        Object[] targetForConvertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            targetForConvertedValues[i] = converter != null ? converter.getAsObject(facesContext, component, values[i]) : values[i];
        }
        return targetForConvertedValues;
    }

    public static Converter getItemConverter(FacesContext facesContext, UIComponent component) {
        Class valueType;
        Converter converter = null;
        if (component instanceof ValueHolder && (converter = ((ValueHolder)component).getConverter()) != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null && (valueType = ve.getType(facesContext.getELContext())) != null && valueType.isArray()) {
            converter = facesContext.getApplication().createConverter(valueType);
        }
        return converter;
    }

    public static UISelectItems getPseudoSelectItems(SelectItemsInterface selectItemsInterface) {
        UISelectItems selectItems = null;
        if (selectItemsInterface.getVar() != null && selectItemsInterface.getItemValues() != null) {
            selectItems = new UISelectItems();
            selectItems.setValue(selectItemsInterface.getItemValues());
            selectItems.getAttributes().put("var", selectItemsInterface.getVar());
            if (selectItemsInterface.getItemValue() != null) {
                selectItems.getAttributes().put("itemValue", selectItemsInterface.getItemValue());
            }
            if (selectItemsInterface.getItemLabel() != null) {
                selectItems.getAttributes().put("itemLabel", selectItemsInterface.getItemLabel());
            }
        }
        return selectItems;
    }
}

