/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.richfaces.component.AbstractDropDownMenu;
import org.richfaces.component.AbstractMenuGroup;
import org.richfaces.component.AbstractMenuItem;
import org.richfaces.component.Mode;
import org.richfaces.renderkit.AjaxCommandRendererBase;
import org.richfaces.renderkit.util.HandlersChain;

public class MenuItemRendererBase
extends AjaxCommandRendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.MenuItemRenderer";

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof AbstractMenuItem) {
            return ((AbstractMenuItem)component).isDisabled();
        }
        return false;
    }

    protected UIComponent getIconFacet(FacesContext facesContext, UIComponent component) {
        UIComponent facet = null;
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        if (menuItem != null) {
            facet = menuItem.isDisabled() ? menuItem.getFacet(AbstractMenuItem.Facets.iconDisabled.toString()) : menuItem.getFacet(AbstractMenuItem.Facets.icon.toString());
        }
        return facet;
    }

    protected String getIconAttribute(FacesContext facesContext, UIComponent component) {
        String icon = null;
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        if (menuItem != null) {
            icon = menuItem.isDisabled() ? menuItem.getIconDisabled() : menuItem.getIcon();
        }
        return icon;
    }

    @Override
    public void doDecode(FacesContext context, UIComponent component) {
        Mode mode;
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        if (menuItem != null && !Mode.client.equals((Object)(mode = this.resolveSubmitMode(menuItem)))) {
            super.doDecode(context, component);
        }
    }

    private UIComponent getUIForm(UIComponent component) {
        if (component != null) {
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof UIForm)) continue;
                return parent;
            }
        }
        return null;
    }

    protected String getOnClickFunction(FacesContext facesContext, UIComponent component) {
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        Mode subminMode = this.resolveSubmitMode(menuItem);
        if (Mode.ajax.equals((Object)subminMode)) {
            return this.getOnClick(facesContext, (UIComponent)menuItem);
        }
        return "";
    }

    @Override
    public String getOnClick(FacesContext context, UIComponent component) {
        StringBuffer onClick = new StringBuffer();
        if (!this.getUtils().isBooleanAttribute(component, "disabled")) {
            HandlersChain handlersChain = new HandlersChain(context, component);
            handlersChain.addBehaviors("click", "action");
            handlersChain.addAjaxSubmitFunction();
            String handlerScript = handlersChain.toScript();
            if (handlerScript != null) {
                onClick.append(handlerScript);
            }
            if (!"reset".equals(component.getAttributes().get("type"))) {
                onClick.append(";return false;");
            }
        } else {
            onClick.append("return false;");
        }
        return onClick.toString();
    }

    protected Mode resolveSubmitMode(AbstractMenuItem menuItem) {
        if (menuItem.getMode() != null) {
            return menuItem.getMode();
        }
        AbstractDropDownMenu parent = this.getDDMenu((UIComponent)menuItem);
        if (parent != null && parent.getMode() != null) {
            return parent.getMode();
        }
        return Mode.server;
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent component, String ddMenuStyle, String menuGroupStyle, String menuItemStyle) {
        AbstractDropDownMenu ddMenu = this.getDDMenu(component);
        AbstractMenuGroup menuGroup = this.getMenuGroup(component);
        String styleClass = null;
        if (ddMenu != null && ddMenuStyle != null && ddMenuStyle.length() > 0) {
            styleClass = (String)ddMenu.getAttributes().get(ddMenuStyle);
        }
        if (menuGroup != null && menuGroupStyle != null && menuGroupStyle.length() > 0) {
            styleClass = this.concatClasses(styleClass, menuGroup.getAttributes().get(menuGroupStyle));
        }
        return this.concatClasses(styleClass, component.getAttributes().get(menuItemStyle));
    }

    private UIComponent getParent(UIComponent component, Class<?> parentClass) {
        if (component != null && parentClass != null) {
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!parentClass.isInstance(parent)) continue;
                return parent;
            }
        }
        return null;
    }

    protected AbstractDropDownMenu getDDMenu(UIComponent component) {
        return (AbstractDropDownMenu)this.getParent(component, AbstractDropDownMenu.class);
    }

    protected AbstractMenuGroup getMenuGroup(UIComponent component) {
        return (AbstractMenuGroup)this.getParent(component, AbstractMenuGroup.class);
    }

    protected boolean isStringEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public String getSubmitMode(UIComponent component) {
        return this.resolveSubmitMode((AbstractMenuItem)component).name();
    }
}

