/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public final class VersionBean {
    public static final Version VERSION = new Version();

    public String getVendor() {
        return VERSION.getImplementationVendor();
    }

    public String getTitle() {
        return VERSION.getImplementationTitle();
    }

    public String getTimestamp() {
        return VERSION.getScmTimestamp();
    }

    public Version getVersion() {
        return VERSION;
    }

    public String toString() {
        return VERSION.toString();
    }

    public static class Version {
        private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
        private static final String UNKNOWN = "";
        private String implementationVendor = "";
        private String implementationVersion = "4.1.0.20111111-CR1";
        private String implementationTitle = "";
        private String scmTimestamp = "";
        private String fullVersionString = "";
        private boolean containsDataFromManifest = false;

        public Version() {
            this.initialize();
        }

        private String getAttributeValueOrDefault(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            if (value == null) {
                value = UNKNOWN;
            }
            return value;
        }

        private void initialize() {
            Manifest manifest = null;
            try {
                manifest = this.readManifest();
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)MessageFormat.format("Error reading project metadata: {0}", e.getMessage()), (Throwable)e);
            }
            if (manifest != null) {
                this.initializePropertiesFromManifest(manifest);
                this.initializeDerivativeProperties();
            }
        }

        private void initializePropertiesFromManifest(Manifest manifest) {
            this.containsDataFromManifest = true;
            Attributes attributes = manifest.getMainAttributes();
            this.implementationVendor = this.getAttributeValueOrDefault(attributes, "Implementation-Vendor");
            this.implementationVersion = this.getAttributeValueOrDefault(attributes, "Implementation-Version");
            this.implementationTitle = this.getAttributeValueOrDefault(attributes, "Implementation-Title");
            this.scmTimestamp = this.getAttributeValueOrDefault(attributes, "SCM-Timestamp");
        }

        private void initializeDerivativeProperties() {
            this.fullVersionString = MessageFormat.format("v.{0}", this.implementationVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private Manifest readManifest() {
            domain = VersionBean.class.getProtectionDomain();
            if (domain != null && (codeSource = domain.getCodeSource()) != null && (url = codeSource.getLocation()) != null) {
                block38: {
                    block36: {
                        block37: {
                            block35: {
                                manifestStream = null;
                                manifestStream = URLToStreamHelper.urlToStream((URL)new URL(url, "META-INF/MANIFEST.MF"));
                                var5_5 = new Manifest(manifestStream);
                                if (manifestStream == null) break block35;
                                try {
                                    manifestStream.close();
                                }
                                catch (IOException e) {
                                    Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                                }
                            }
                            return var5_5;
                            catch (MalformedURLException e1) {
                                if (Version.LOGGER.isDebugEnabled()) {
                                    Version.LOGGER.debug((CharSequence)e1.getMessage(), (Throwable)e1);
                                }
                                ** if (manifestStream == null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        manifestStream.close();
                                    }
                                    catch (IOException e) {
                                        Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                                    }
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                            }
                            catch (IOException e) {
                                if (Version.LOGGER.isDebugEnabled()) {
                                    Version.LOGGER.debug((CharSequence)e.getMessage(), (Throwable)e);
                                }
                                ** if (manifestStream == null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        manifestStream.close();
                                    }
                                    catch (IOException e) {
                                        Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                                    }
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                                {
                                    catch (Throwable var7_15) {
                                        if (manifestStream != null) {
                                            try {
                                                manifestStream.close();
                                            }
                                            catch (IOException e) {
                                                Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                                            }
                                        }
                                        throw var7_15;
                                    }
                                }
                            }
                            jis = null;
                            urlConnection = url.openConnection();
                            urlConnection.setUseCaches(false);
                            if (!(urlConnection instanceof JarURLConnection)) break block36;
                            jarUrlConnection = (JarURLConnection)urlConnection;
                            e = jarUrlConnection.getManifest();
                            if (jis == null) break block37;
                            try {
                                jis.close();
                            }
                            catch (IOException e) {
                                Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                            }
                        }
                        return e;
                    }
                    jis = new JarInputStream(urlConnection.getInputStream());
                    var7_17 = jis.getManifest();
                    if (jis == null) break block38;
                    try {
                        jis.close();
                    }
                    catch (IOException e) {
                        Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                    }
                }
                return var7_17;
                catch (IOException e) {
                    try {
                        Version.LOGGER.error((CharSequence)MessageFormat.format("Error reading META-INF/MANIFEST.MF file: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                        ** if (jis == null) goto lbl-1000
                    }
                    catch (Throwable var10_22) {
                        if (jis != null) {
                            try {
                                jis.close();
                            }
                            catch (IOException e) {
                                Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                            }
                        }
                        throw var10_22;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            jis.close();
                        }
                        catch (IOException e) {
                            Version.LOGGER.error((CharSequence)MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), (Throwable)e);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
            return null;
        }

        boolean containsDataFromManifest() {
            return this.containsDataFromManifest;
        }

        public String getVersion() {
            return this.fullVersionString;
        }

        public String getImplementationTitle() {
            return this.implementationTitle;
        }

        public String getImplementationVendor() {
            return this.implementationVendor;
        }

        public String getImplementationVersion() {
            return this.implementationVersion;
        }

        public String getScmTimestamp() {
            return this.scmTimestamp;
        }

        public String toString() {
            if (this.containsDataFromManifest()) {
                return this.getImplementationTitle() + " by " + this.getImplementationVendor() + ", version " + this.getVersion();
            }
            return this.getVersion();
        }
    }
}

