/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

public class JSEncoder {
    private static final char[] ENCODE_HEX = "0123456789ABCDEF".toCharArray();
    private static final char[] ENCODE_QUOT = "\\\"".toCharArray();
    private static final char[] ENCODE_LF = "\\n".toCharArray();
    private static final char[] ENCODE_BC = "\\b".toCharArray();
    private static final char[] ENCODE_FF = "\\f".toCharArray();
    private static final char[] ENCODE_CR = "\\r".toCharArray();
    private static final char[] ENCODE_TAB = "\\t".toCharArray();
    private static final char[] ENCODE_BS = "\\\\".toCharArray();
    private static final char[] ENCODE_FS = "\\/".toCharArray();

    public boolean compile(char c) {
        return c != '\b' && !(c == '\f' | c == '\t') && c != '\n' && c != '\r' && c != '\"' && c != '\\' && c != '/' && c != ']' && c != '<' && c != '>' && c != '&' && c != '-' && c >= ' ' && (c <= '\ud7ff' || c >= '\ue000') && c <= '\ufffd' && c <= '\u00ff';
    }

    public char[] encode(char c) {
        switch (c) {
            case '\b': {
                return ENCODE_BC;
            }
            case '\f': {
                return ENCODE_FF;
            }
            case '\t': {
                return ENCODE_TAB;
            }
            case '\n': {
                return ENCODE_LF;
            }
            case '\r': {
                return ENCODE_CR;
            }
            case '\"': {
                return ENCODE_QUOT;
            }
            case '\\': {
                return ENCODE_BS;
            }
            case '/': {
                return ENCODE_FS;
            }
        }
        char[] ret = new char[]{'\\', 'u', ENCODE_HEX[c >> 12 & 0xF], ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF]};
        return ret;
    }
}

