/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.el.ELContext;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.PushContextFactory;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicKey;
import org.richfaces.el.util.ELUtils;

public abstract class TopicsContext {
    private ConcurrentMap<String, Topic> topics = new ConcurrentHashMap<String, Topic>();

    protected abstract Topic createTopic(TopicKey var1);

    public Topic getOrCreateTopic(TopicKey key) {
        Topic result = (Topic)this.topics.get(key.getTopicName());
        if (result == null) {
            Topic newTopic = this.createTopic(key);
            result = this.topics.putIfAbsent(key.getTopicName(), newTopic);
            if (result == null) {
                result = newTopic;
            }
        }
        return result;
    }

    public Topic getTopic(TopicKey key) {
        return (Topic)this.topics.get(key.getTopicName());
    }

    public void removeTopic(TopicKey key) {
        this.topics.remove(key.getTopicName());
    }

    public void publish(TopicKey key, Object data) throws MessageException {
        TopicKey resolvedKey = this.getTopicKeyWithResolvedExpressions(key);
        Topic topic = this.getTopic(resolvedKey);
        if (topic == null) {
            throw new MessageException(MessageFormat.format("Topic {0} not found", resolvedKey.getTopicName()));
        }
        topic.publish(resolvedKey, data);
    }

    public static TopicsContext lookup() {
        return ServiceTracker.getService(PushContextFactory.class).getPushContext().getTopicsContext();
    }

    protected TopicKey getTopicKeyWithResolvedExpressions(TopicKey key) {
        String topicName = key.getTopicName();
        String subtopicName = key.getSubtopicName();
        String topicAddress = key.getTopicAddress();
        if (this.isExpression(topicName) || this.isExpression(subtopicName)) {
            topicName = this.evaluateExpression(topicName);
            subtopicName = this.evaluateExpression(subtopicName);
            return new TopicKey(topicName, subtopicName);
        }
        if (this.isExpression(topicAddress)) {
            topicAddress = this.evaluateExpression(topicAddress);
            return new TopicKey(topicAddress);
        }
        return key;
    }

    private boolean isExpression(String expression) {
        return ELUtils.isValueReference(expression);
    }

    private String evaluateExpression(String expression) {
        if (this.isExpression(expression)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object evaluated = ELUtils.evaluateValueExpression(ELUtils.createValueExpression(expression), elContext);
            if (evaluated == null) {
                throw new NullPointerException("expression '" + expression + "' was evaluated to null");
            }
            return evaluated.toString();
        }
        return expression;
    }
}

