/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public final class ResourceMappingConfiguration {
    private static final Logger LOG = RichfacesLogger.CONFIG.getLogger();
    private static final String STATIC_RESOURCE_DEPRECATION_LOGGED = "org.richfaces.staticResourceLocation.deprecation.logged";

    static boolean isEnabled() {
        if (ResourceMappingConfiguration.getStaticResourceLocation() != null) {
            return true;
        }
        return ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)FacesContext.getCurrentInstance(), (Enum)CoreConfiguration.Items.resourceMappingEnabled);
    }

    static String getLocation() {
        if (ResourceMappingConfiguration.getStaticResourceLocation() != null) {
            return ResourceMappingConfiguration.getStaticResourceLocation();
        }
        return ResourceMappingConfiguration.getConfiguration(CoreConfiguration.Items.resourceMappingLocation);
    }

    static String getResourceMappingFile() {
        if (ResourceMappingConfiguration.getStaticResourceLocation() != null) {
            return "META-INF/richfaces/static-resource-mappings.properties";
        }
        return ResourceMappingConfiguration.getConfiguration(CoreConfiguration.Items.resourceMappingFile);
    }

    private static String getStaticResourceLocation() {
        String staticResourceLocation = ResourceMappingConfiguration.getConfiguration(CoreConfiguration.Items.staticResourceLocation);
        ResourceMappingConfiguration.logDeprecation(staticResourceLocation);
        return staticResourceLocation;
    }

    private static void logDeprecation(String staticResourceLocation) {
        Map applicationMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        if (staticResourceLocation != null && !applicationMap.containsKey(STATIC_RESOURCE_DEPRECATION_LOGGED)) {
            applicationMap.put(STATIC_RESOURCE_DEPRECATION_LOGGED, Boolean.TRUE);
            LOG.warn((CharSequence)"Context-param 'org.richfaces.staticResourceLocation' is deprecated, it was replaced by 'org.richfaces.resourceMapping.enabled', 'org.richfaces.resourceMapping.location' and 'org.richfaces.resourceMapping.mappingFile'");
        }
    }

    static String getConfiguration(CoreConfiguration.Items configurationItem) {
        return ConfigurationServiceHelper.getStringConfigurationValue((FacesContext)FacesContext.getCurrentInstance(), (Enum)configurationItem);
    }
}

