/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.application.push.PushContext;
import org.richfaces.application.push.PushContextFactory;
import org.richfaces.application.push.impl.PushContextImpl;

public class PushContextFactoryImpl
implements PushContextFactory {
    public static final String PUSH_HANDLER_MAPPING_ATTRIBUTE = PushContextFactoryImpl.class.getName();
    public static final String PUSH_CONTEXT_RESOURCE_NAME = "__richfaces_push";

    private static String getApplicationContextName(FacesContext facesContext) {
        Object contextObject = facesContext.getExternalContext().getContext();
        if (contextObject instanceof ServletContext) {
            return ((ServletContext)contextObject).getContextPath();
        }
        return "/";
    }

    private static String convertToUrl(FacesContext facesContext, String mapping) {
        if (mapping == null) {
            return mapping;
        }
        String url = mapping.replaceAll(Pattern.quote("*"), PUSH_CONTEXT_RESOURCE_NAME);
        if (!url.startsWith("/")) {
            url = '/' + url;
        }
        return PushContextFactoryImpl.getApplicationContextName(facesContext) + url;
    }

    private static PushContext createInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String pushHandlerMapping = (String)facesContext.getExternalContext().getApplicationMap().get(PUSH_HANDLER_MAPPING_ATTRIBUTE);
        if (pushHandlerMapping == null) {
            pushHandlerMapping = ConfigurationServiceHelper.getStringConfigurationValue((FacesContext)facesContext, (Enum)CoreConfiguration.Items.pushHandlerMapping);
        }
        PushContextImpl pushContext = new PushContextImpl(PushContextFactoryImpl.convertToUrl(facesContext, pushHandlerMapping));
        pushContext.init(facesContext);
        return pushContext;
    }

    public PushContext getPushContext() {
        return PushContextHolder.INSTANCE;
    }

    static /* synthetic */ PushContext access$000() {
        return PushContextFactoryImpl.createInstance();
    }

    private static final class PushContextHolder {
        static final PushContext INSTANCE = PushContextFactoryImpl.access$000();

        private PushContextHolder() {
        }
    }
}

