/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CreateParser {
    private DefaultHandler handler;
    private SAXParser saxParser;

    public CreateParser(DefaultHandler handler) throws SAXException, ParserConfigurationException {
        this.handler = handler;
        this.create();
    }

    private void create() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.saxParser = factory.newSAXParser();
    }

    public void parse(File file) throws IOException, SAXException {
        this.saxParser.parse(file, this.handler);
    }

    public void parse(String uri) throws IOException, SAXException {
        this.saxParser.parse(uri, this.handler);
    }

    public void parse(InputStream stream) throws IOException, SAXException {
        this.saxParser.parse(stream, this.handler);
    }
}

