/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UpdateModelException;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import org.richfaces.application.FacesMessages;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.AbstractDivPanel;
import org.richfaces.component.AbstractTogglePanelItemInterface;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.SwitchType;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.event.ItemChangeEvent;
import org.richfaces.event.ItemChangeListener;
import org.richfaces.event.ItemChangeSource;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.util.RendererUtils;

public abstract class AbstractTogglePanel
extends UIOutput
implements AbstractDivPanel,
ItemChangeSource,
MetaComponentResolver,
MetaComponentEncoder {
    public static final String ACTIVE_ITEM_META_COMPONENT = "activeItem";
    public static final String COMPONENT_TYPE = "org.richfaces.TogglePanel";
    public static final String COMPONENT_FAMILY = "org.richfaces.TogglePanel";
    public static final String META_NAME_FIRST = "@first";
    public static final String META_NAME_PREV = "@prev";
    public static final String META_NAME_NEXT = "@next";
    public static final String META_NAME_LAST = "@last";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    private String submittedActiveItem = null;

    protected AbstractTogglePanel() {
        this.setRendererType("org.richfaces.TogglePanelRenderer");
    }

    public Object getSubmittedValue() {
        return this.submittedActiveItem;
    }

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedActiveItem = String.valueOf(submittedValue);
    }

    public boolean isLocalValueSet() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.localValueSet), (Object)false);
    }

    public void setLocalValueSet(boolean localValueSet) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.localValueSet), (Object)localValueSet);
    }

    public boolean isValid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.valid), (Object)true);
    }

    public void setValid(boolean valid) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.valid), (Object)valid);
    }

    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), (Object)false);
    }

    public void setRequired(boolean required) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), (Object)required);
    }

    @Attribute
    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), (Object)false);
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), (Object)immediate);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        List<AbstractTogglePanelItemInterface> renderedItems;
        AbstractTogglePanelItemInterface item = null;
        String activeItem = this.getActiveItem();
        if (!Strings.isNullOrEmpty((String)activeItem)) {
            item = this.getItem(activeItem);
        }
        if (!(item != null && ((UIComponent)item).isRendered() || (renderedItems = this.getRenderedItems()).isEmpty())) {
            this.setActiveItem(renderedItems.get(0).getName());
        }
        super.encodeBegin(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        String activeItem = this.getActiveItemValue();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isActiveItem(kid, activeItem) && this.getSwitchType() != SwitchType.client) continue;
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
        ItemChangeEvent event = this.createItemChangeEvent(context);
        if (event != null) {
            event.queue();
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, (Object)this);
        Iterator kids = this.getFacetsAndChildren();
        String activeItem = this.getActiveItemValue();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isActiveItem(kid, activeItem) && this.getSwitchType() != SwitchType.client) continue;
            kid.processValidators(context);
        }
        app.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        String activeItem = this.getActiveItemValue();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isActiveItem(kid, activeItem) && this.getSwitchType() != SwitchType.client) continue;
            kid.processUpdates(context);
        }
        this.popComponentFromEL(context);
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return;
        }
        Throwable caught = null;
        FacesMessage message = null;
        try {
            ve.setValue(context.getELContext(), this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (ELException e) {
            caught = e;
            String messageStr = e.getMessage();
            for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                messageStr = result.getMessage();
            }
            message = messageStr == null ? ((MessageFactory)ServiceTracker.getService(MessageFactory.class)).createMessage(context, FacesMessage.SEVERITY_ERROR, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel(context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
            this.setValid(false);
        }
        catch (Exception e) {
            caught = e;
            this.setValid(false);
        }
        if (caught != null) {
            assert (message != null);
            UpdateModelException toQueue = new UpdateModelException(message, caught);
            ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(context, (Throwable)toQueue, (UIComponent)this, PhaseId.UPDATE_MODEL_VALUES);
            context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, (Object)eventContext);
        }
    }

    private ItemChangeEvent createItemChangeEvent(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String activeItem = this.getSubmittedActiveItem();
        if (activeItem == null) {
            return null;
        }
        String previous = (String)this.getValue();
        if (previous == null || !previous.equalsIgnoreCase(activeItem)) {
            UIComponent prevComp = null;
            UIComponent actvComp = null;
            if (previous != null) {
                prevComp = (UIComponent)this.getItem(previous);
            }
            if (activeItem != null) {
                actvComp = (UIComponent)this.getItem(activeItem);
            }
            return new ItemChangeEvent((UIComponent)this, previous, prevComp, activeItem, actvComp);
        }
        return null;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ItemChangeEvent && event.getComponent() == this) {
            this.setEventPhase((ItemChangeEvent)event);
        }
        super.queueEvent(event);
    }

    protected void setEventPhase(ItemChangeEvent event) {
        if (this.isImmediate() || event.getNewItem() != null && RendererUtils.getInstance().isBooleanAttribute(event.getNewItem(), "immediate")) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        }
    }

    protected void setEventPhase(FacesEvent event) {
        if (this.isImmediate()) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (event instanceof ItemChangeEvent) {
            this.setValue(((ItemChangeEvent)event).getNewItemName());
            this.setSubmittedActiveItem(null);
            if (event.getPhaseId() == PhaseId.UPDATE_MODEL_VALUES) {
                try {
                    this.updateModel(context);
                }
                catch (RuntimeException e) {
                    context.renderResponse();
                    throw e;
                }
            } else {
                context.renderResponse();
            }
        }
        super.broadcast(event);
    }

    public String getFamily() {
        return "org.richfaces.TogglePanel";
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String getActiveItemValue() {
        String value = this.getActiveItem();
        if (value == null) {
            value = this.getSubmittedActiveItem();
        }
        return value;
    }

    protected boolean isActiveItem(UIComponent kid) {
        return this.isActiveItem(kid, this.getActiveItemValue());
    }

    protected boolean isActiveItem(UIComponent kid, String value) {
        if (kid == null || value == null) {
            return false;
        }
        return AbstractTogglePanel.getChildName(kid).equals(value);
    }

    private static String getChildName(UIComponent item) {
        if (item == null) {
            return null;
        }
        if (!(item instanceof AbstractTogglePanelItemInterface)) {
            throw new IllegalArgumentException();
        }
        return ((AbstractTogglePanelItemInterface)item).getName();
    }

    public AbstractTogglePanelItemInterface getItemByIndex(int index) {
        List<AbstractTogglePanelItemInterface> children = this.getRenderedItems();
        if (index < 0 || index >= children.size()) {
            return null;
        }
        if (this.isCycledSwitching()) {
            int size = this.getRenderedItems().size();
            return children.get((size + index) % size);
        }
        return children.get(index);
    }

    public List<AbstractTogglePanelItemInterface> getRenderedItems() {
        return this.getItems(false);
    }

    public List<AbstractTogglePanelItemInterface> getItems(boolean isRendered) {
        ArrayList<AbstractTogglePanelItemInterface> res = new ArrayList<AbstractTogglePanelItemInterface>(this.getChildCount());
        for (UIComponent child : this.getChildren()) {
            if (!isRendered && !child.isRendered() || !(child instanceof AbstractTogglePanelItemInterface)) continue;
            res.add((AbstractTogglePanelItemInterface)child);
        }
        return res;
    }

    public AbstractTogglePanelItemInterface getItem(String name) {
        if (META_NAME_FIRST.equals(name)) {
            return this.getFirstItem();
        }
        if (META_NAME_PREV.equals(name)) {
            return this.getPrevItem();
        }
        if (META_NAME_NEXT.equals(name)) {
            return this.getNextItem();
        }
        if (META_NAME_LAST.equals(name)) {
            return this.getLastItem();
        }
        return this.getItemByIndex(this.getChildIndex(name));
    }

    public AbstractTogglePanelItemInterface getFirstItem() {
        return this.getItemByIndex(0);
    }

    public AbstractTogglePanelItemInterface getPrevItem() {
        return this.getPrevItem(this.getActiveItem());
    }

    public AbstractTogglePanelItemInterface getPrevItem(String name) {
        return this.getItemByIndex(this.getChildIndex(name) - 1);
    }

    public AbstractTogglePanelItemInterface getNextItem() {
        return this.getNextItem(this.getActiveItem());
    }

    public AbstractTogglePanelItemInterface getNextItem(String name) {
        return this.getItemByIndex(this.getChildIndex(name) + 1);
    }

    public AbstractTogglePanelItemInterface getLastItem() {
        return this.getItemByIndex(this.getRenderedItems().size() - 1);
    }

    public int getChildIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is required parameter.");
        }
        List<AbstractTogglePanelItemInterface> items = this.getRenderedItems();
        for (int ind = 0; ind < items.size(); ++ind) {
            if (!name.equals(items.get(ind).getName())) continue;
            return ind;
        }
        return Integer.MIN_VALUE;
    }

    public String getSubmittedActiveItem() {
        return this.submittedActiveItem;
    }

    public void setSubmittedActiveItem(String submittedActiveItem) {
        this.submittedActiveItem = submittedActiveItem;
    }

    @Attribute(hidden=true)
    public void setValue(Object value) {
        super.setValue(value);
        this.setLocalValueSet(true);
    }

    @Attribute
    public String getActiveItem() {
        return (String)this.getValue();
    }

    public void setActiveItem(String value) {
        this.setValue(value);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (ACTIVE_ITEM_META_COMPONENT.equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    @Attribute(generate=false)
    public SwitchType getSwitchType() {
        SwitchType switchType = (SwitchType)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.switchType));
        if (switchType == null) {
            switchType = SwitchType.DEFAULT;
        }
        return switchType;
    }

    public void setSwitchType(SwitchType switchType) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.switchType), (Object)switchType);
    }

    @Attribute(hidden=true)
    public abstract boolean isLimitRender();

    @Attribute
    public abstract boolean isCycledSwitching();

    @Attribute(hidden=true)
    public abstract Object getData();

    @Attribute(hidden=true)
    public abstract String getStatus();

    @Attribute(hidden=true)
    public abstract Object getExecute();

    @Attribute(hidden=true)
    public abstract Object getRender();

    @Attribute
    public abstract MethodExpression getItemChangeListener();

    @Attribute(events={@EventName(value="itemchange")})
    public abstract String getOnitemchange();

    @Attribute(events={@EventName(value="beforeitemchange")})
    public abstract String getOnbeforeitemchange();

    public void addItemChangeListener(ItemChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ItemChangeListener[] getItemChangeListeners() {
        return (ItemChangeListener[])this.getFacesListeners(ItemChangeListener.class);
    }

    public void removeItemChangeListener(ItemChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (ACTIVE_ITEM_META_COMPONENT.equals(metaComponentId)) {
            return this.getClientId(facesContext) + '@' + metaComponentId;
        }
        return null;
    }

    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        ((MetaComponentRenderer)this.getRenderer(context)).encodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block10: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext facesContext = context.getFacesContext();
            this.pushComponentToEL(facesContext, null);
            try {
                ExtendedVisitContext extendedVisitContext;
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result == VisitResult.ACCEPT && context instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)context).getVisitMode() == ExtendedVisitContextMode.RENDER && (result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, ACTIVE_ITEM_META_COMPONENT)) == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT) break block10;
                Iterator kids = this.getFacetsAndChildren();
                while (kids.hasNext()) {
                    boolean done = ((UIComponent)kids.next()).visitTree(context, callback);
                    if (!done) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
            }
        }
        return false;
    }

    private static enum PropertyKeys {
        localValueSet,
        required,
        valid,
        immediate,
        switchType;

    }
}

