/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.Mode;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.MenuItemRendererBase;
import org.richfaces.renderkit.util.RendererUtils;

@ResourceDependencies(value={@ResourceDependency(name="ajax.reslib", library="org.richfaces", target=""), @ResourceDependency(name="base-component.reslib", library="org.richfaces", target=""), @ResourceDependency(name="richfaces-event.js", library="", target=""), @ResourceDependency(name="menuitem.js", library="org.richfaces", target="")})
public class MenuItemRenderer
extends MenuItemRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES34 = RenderKitUtils.attributes().generic("align", "align", new String[0]).generic("dir", "dir", new String[0]).generic("lang", "lang", new String[0]).generic("onclick", "onclick", "click").generic("ondblclick", "ondblclick", "dblclick").generic("onkeydown", "onkeydown", "keydown").generic("onkeypress", "onkeypress", "keypress").generic("onkeyup", "onkeyup", "keyup").generic("onmousedown", "onmousedown", "mousedown").generic("onmousemove", "onmousemove", "mousemove").generic("onmouseout", "onmouseout", "mouseout").generic("onmouseover", "onmouseover", "mouseover").generic("onmouseup", "onmouseup", "mouseup").generic("title", "title", new String[0]);

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    private static boolean convertToBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return Boolean.TRUE.equals(object);
        }
        return Boolean.valueOf(object.toString());
    }

    private static boolean isEmpty(Object object) {
        return object == null || object.toString().length() == 0;
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Object text;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        Object style = component.getAttributes().get("style");
        Object cssRoot = component.getAttributes().get("cssRoot");
        String iconClass = this.getStyleClass(facesContext, component, "", "iconClass", "iconClass");
        String labelClass = this.getStyleClass(facesContext, component, "", "labelClass", "labelClass");
        String styleClass = this.getStyleClass(facesContext, component, "itemClass", "styleClass", "styleClass");
        String selectedClass = this.getStyleClass(facesContext, component, "selectedItemClass", "selectedClass", "selectedClass");
        String disabledClass = this.getStyleClass(facesContext, component, "disabledItemClass", "disabledClass", "disabledClass");
        boolean isDisabled = this.isDisabled(facesContext, component);
        UIComponent iconFacet = this.getIconFacet(facesContext, component);
        String iconAttribute = this.getIconAttribute(facesContext, component);
        responseWriter.startElement("div", component);
        String value = "rf-" + MenuItemRenderer.convertToString(cssRoot) + "-itm " + MenuItemRenderer.convertToString(MenuItemRenderer.convertToBoolean(isDisabled) ? "rf-" + cssRoot + "-itm-dis " + disabledClass : "rf-" + cssRoot + "-itm-unsel " + styleClass);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        if (null != (value = style) && RenderKitUtils.shouldRenderAttribute(value)) {
            responseWriter.writeAttribute("style", (Object)value, null);
        }
        RenderKitUtils.renderPassThroughAttributes(facesContext, component, PASS_THROUGH_ATTRIBUTES34);
        responseWriter.startElement("div", component);
        value = "rf-" + MenuItemRenderer.convertToString(cssRoot) + "-itm-ic " + MenuItemRenderer.convertToString(iconClass);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (iconFacet != null && MenuItemRenderer.convertToBoolean(iconFacet.isRendered())) {
            iconFacet.encodeAll(facesContext);
        } else if (!MenuItemRenderer.convertToBoolean(this.isStringEmpty(iconAttribute))) {
            responseWriter.startElement("img", component);
            responseWriter.writeAttribute("alt", (Object)"", null);
            responseWriter.writeAttribute("height", (Object)"16", null);
            value = RenderKitUtils.getResourceURL(iconAttribute, facesContext);
            if (null != value && value.toString().length() > 0) {
                responseWriter.writeURIAttribute("src", (Object)value, null);
            }
            responseWriter.writeAttribute("width", (Object)"16", null);
            responseWriter.endElement("img");
        } else {
            responseWriter.startElement("div", component);
            value = "rf-" + MenuItemRenderer.convertToString(cssRoot) + "-emptyIcon";
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            responseWriter.endElement("div");
        }
        responseWriter.endElement("div");
        if (!MenuItemRenderer.convertToBoolean(isDisabled)) {
            responseWriter.startElement("span", component);
            value = "rf-" + MenuItemRenderer.convertToString(cssRoot) + "-itm-lbl " + MenuItemRenderer.convertToString(labelClass);
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            if (!MenuItemRenderer.isEmpty(component.getAttributes().get("label"))) {
                text = component.getAttributes().get("label");
                if (text != null) {
                    responseWriter.writeText(text, null);
                }
            } else {
                this.renderChildren(facesContext, component);
            }
            responseWriter.endElement("span");
        } else if (!MenuItemRenderer.isEmpty(component.getAttributes().get("label"))) {
            text = component.getAttributes().get("label");
            if (text != null) {
                responseWriter.writeText(text, null);
            }
        } else {
            this.renderChildren(facesContext, component);
        }
        if (!MenuItemRenderer.convertToBoolean(isDisabled)) {
            responseWriter.startElement("script", component);
            responseWriter.writeAttribute("type", (Object)"text/javascript", null);
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
            RenderKitUtils.addToScriptHash(options, "params", RendererUtils.getInstance().createParametersMap(facesContext, component), null, null);
            RenderKitUtils.addToScriptHash(options, "mode", this.getSubmitMode(component), Mode.server, null);
            RenderKitUtils.addToScriptHash(options, "cssRoot", cssRoot, "ddm", null);
            RenderKitUtils.addToScriptHash(options, "submitFunction", this.getOnClickFunction(facesContext, component), null, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
            String text2 = "new RichFaces.ui.MenuItem(" + MenuItemRenderer.convertToString(RenderKitUtils.toScriptArgs(clientId, options)) + ");";
            if (text2 != null) {
                responseWriter.writeText((Object)text2, null);
            }
            responseWriter.endElement("script");
        }
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

