/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.richfaces.request.MultipartRequest;
import org.richfaces.request.ProgressControl;

abstract class BaseMultipartRequest
extends HttpServletRequestWrapper
implements MultipartRequest {
    static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    static final Map<String, String> HEADERS_MAP = Maps.newHashMap();
    private String uploadId;
    private ProgressControl progressControl;

    public BaseMultipartRequest(HttpServletRequest request, String uploadId, ProgressControl progressControl) {
        super(request);
        this.uploadId = uploadId;
        this.progressControl = progressControl;
    }

    @Override
    public String getUploadId() {
        return this.uploadId;
    }

    @Override
    public void release() {
        this.progressControl.clearProgress();
    }

    public String getHeader(String name) {
        String headerValue = HEADERS_MAP.get(name.toLowerCase(Locale.US));
        if (!Strings.isNullOrEmpty((String)headerValue)) {
            return headerValue;
        }
        return super.getHeader(name);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    static {
        HEADERS_MAP.put("accept", "text/html");
        HEADERS_MAP.put("faces-request", "partial/ajax");
        HEADERS_MAP.put("content-type", CONTENT_TYPE);
    }
}

