/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.richfaces.VersionBean;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.DefaultModule;
import org.richfaces.application.Module;
import org.richfaces.application.ServiceException;
import org.richfaces.application.ServiceLoader;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.ServicesFactory;
import org.richfaces.application.ServicesFactoryImpl;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.application.push.PushContextFactory;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class InitializationListener
implements SystemEventListener {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();

    public boolean isListenerForSource(Object source) {
        return true;
    }

    protected void onStart() {
        String versionString;
        this.createFactory();
        if (LOGGER.isInfoEnabled() && (versionString = VersionBean.VERSION.toString()) != null && versionString.length() != 0) {
            LOGGER.info((CharSequence)versionString);
        }
        if (this.getConfiguration(CoreConfiguration.Items.executeAWTInitializer).booleanValue()) {
            this.initializeAWT();
        }
        if (this.getConfiguration(CoreConfiguration.Items.pushInitializePushContextOnStartup).booleanValue()) {
            this.initializePushContext();
        }
        if (this.getConfiguration(CoreConfiguration.Items.pushJMSEnabled) == null || !this.getConfiguration(CoreConfiguration.Items.pushJMSEnabled).booleanValue()) {
            this.logWarningWhenConnectionFactoryPresent();
        }
    }

    private void initializeAWT() {
        try {
            AWTInitializer.initialize();
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn((CharSequence)MessageFormat.format("There were problems loading class: {0} - AWTInitializer won't be run", e.getMessage()));
        }
    }

    private void initializePushContext() {
        try {
            LOGGER.info((CharSequence)"Startup initialization of PushContext");
            ((PushContextFactory)ServiceTracker.getService(PushContextFactory.class)).getPushContext();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)MessageFormat.format("There were problems initializing PushContext on startup: {0}", e.getMessage()));
        }
    }

    private void logWarningWhenConnectionFactoryPresent() {
        try {
            Class.forName("javax.jms.ConnectionFactory");
            LOGGER.warn((CharSequence)"JMS API was found on the classpath; if you want to enable RichFaces Push JMS integration, set context-param 'org.richfaces.push.jms.enabled' in web.xml");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private Boolean getConfiguration(Enum<?> configuration) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)facesContext, configuration);
    }

    protected ServicesFactory createFactory() {
        ServicesFactoryImpl injector = new ServicesFactoryImpl();
        ServiceTracker.setFactory((ServicesFactory)injector);
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(new DefaultModule());
        try {
            modules.addAll(ServiceLoader.loadServices(Module.class));
            injector.init(modules);
        }
        catch (ServiceException e) {
            throw new FacesException((Throwable)e);
        }
        return injector;
    }

    protected void onStop() {
        ServiceTracker.release();
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PostConstructApplicationEvent) {
            this.onStart();
        } else if (event instanceof PreDestroyApplicationEvent) {
            this.onStop();
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Event {0} is not supported!", event));
        }
    }

    private static final class AWTInitializer {
        private AWTInitializer() {
        }

        private static boolean checkGetSystemClassLoaderAccess() {
            try {
                ClassLoader.getSystemClassLoader();
                return true;
            }
            catch (SecurityException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void initialize() {
            if (!AWTInitializer.checkGetSystemClassLoaderAccess()) {
                LOGGER.warn((CharSequence)"Access to system class loader restricted - AWTInitializer won't be run");
                return;
            }
            Thread thread = Thread.currentThread();
            ClassLoader initialTCCL = thread.getContextClassLoader();
            ImageInputStream testStream = null;
            try {
                ClassLoader systemCL = ClassLoader.getSystemClassLoader();
                thread.setContextClassLoader(systemCL);
                ImageIO.setUseCache(false);
                testStream = ImageIO.createImageInputStream(new ByteArrayInputStream(new byte[0]));
                Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
            catch (IOException e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
            finally {
                if (testStream != null) {
                    try {
                        testStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                thread.setContextClassLoader(initialTCCL);
            }
        }
    }
}

