/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.PanelMenuMode;
import org.richfaces.component.AbstractPanelMenuGroup;
import org.richfaces.component.AbstractPanelMenuItem;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.html.PanelMenuGroupHeaderRenderer;
import org.richfaces.renderkit.html.PanelMenuItemRenderer;
import org.richfaces.renderkit.html.TableIconsRendererHelper;
import org.richfaces.renderkit.html.TogglePanelRenderer;

public class PanelMenuGroupRenderer
extends DivPanelRenderer {
    public static final String COLLAPSE = "collapse";
    public static final String EXPAND = "expand";
    public static final String SWITCH = "switch";
    public static final String BEFORE_COLLAPSE = "beforecollapse";
    public static final String BEFORE_EXPAND = "beforeexpand";
    public static final String BEFORE_SWITCH = "beforeswitch";
    public static final String BEFORE_SELECT = "beforeselect";
    public static final String SELECT = "select";
    private static final String CSS_CLASS_PREFIX = "rf-pm-gr";
    private static final String TOP_CSS_CLASS_PREFIX = "rf-pm-top-gr";
    private static final String DEFAULT_EXPAND_EVENT = "click";
    private static final String DEFAULT_COLLAPSE_EVENT = "click";
    private final TableIconsRendererHelper<AbstractPanelMenuGroup> headerRenderer = new PanelMenuGroupHeaderRenderer("rf-pm-gr");
    private final TableIconsRendererHelper<AbstractPanelMenuGroup> topHeaderRenderer = new PanelMenuGroupHeaderRenderer("rf-pm-top-gr");

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        AbstractPanelMenuGroup menuGroup = (AbstractPanelMenuGroup)component;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(component.getClientId(context) + ":expanded");
        if (newValue != null) {
            menuGroup.setSubmittedExpanded(newValue);
        }
        if (requestMap.get(clientId = component.getClientId(context)) != null) {
            new ActionEvent(component).queue();
            context.getPartialViewContext().getRenderIds().add(clientId);
            PanelMenuItemRenderer.addOnCompleteParam(context, clientId);
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        AbstractPanelMenuGroup menuGroup = (AbstractPanelMenuGroup)component;
        writer.startElement("input", component);
        String expanded = component.getClientId(context) + ":expanded";
        writer.writeAttribute("id", (Object)expanded, null);
        writer.writeAttribute("name", (Object)expanded, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)String.valueOf(menuGroup.getState()), null);
        writer.endElement("input");
        this.encodeHeader(writer, context, menuGroup);
        this.encodeContentBegin(writer, context, menuGroup);
    }

    private void encodeHeader(ResponseWriter writer, FacesContext context, AbstractPanelMenuGroup menuGroup) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(menuGroup.getClientId(context) + ":hdr"), null);
        writer.writeAttribute("class", (Object)this.concatClasses(this.getCssClass(menuGroup, "-hdr"), "rf-pm-hdr-" + (menuGroup.getState() ? "exp" : "colps"), menuGroup.getPanelMenu().isBubbleSelection() && menuGroup.hasActiveItem((UIComponent)menuGroup, menuGroup.getPanelMenu().getActiveItem()) ? this.getCssClass(menuGroup, "-sel") : "", PanelMenuItemRenderer.isParentPanelMenuDisabled(menuGroup) || menuGroup.isDisabled() ? this.getCssClass(menuGroup, "-hdr-dis") : null), null);
        (menuGroup.isTopItem() ? this.topHeaderRenderer : this.headerRenderer).encodeHeader(writer, context, menuGroup);
        writer.endElement("div");
    }

    public String getCssClass(AbstractPanelMenuItem item, String postfix) {
        return (item.isTopItem() ? TOP_CSS_CLASS_PREFIX : CSS_CLASS_PREFIX) + postfix;
    }

    private void encodeContentBegin(ResponseWriter writer, FacesContext context, AbstractPanelMenuGroup menuGroup) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(menuGroup.getClientId(context) + ":cnt"), null);
        writer.writeAttribute("class", (Object)this.concatClasses(this.getCssClass(menuGroup, "-cnt"), menuGroup.getState() ? "rf-pm-exp" : "rf-pm-colps"), null);
        this.writeJavaScript(writer, context, (UIComponent)menuGroup);
    }

    private void encodeContentEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        return this.concatClasses(this.getCssClass(menuItem, ""), PanelMenuGroupRenderer.attributeAsString(component, "styleClass"), PanelMenuItemRenderer.isParentPanelMenuDisabled(menuItem) || menuItem.isDisabled() ? this.getCssClass(menuItem, "-dis") : "", PanelMenuItemRenderer.isParentPanelMenuDisabled(menuItem) || menuItem.isDisabled() ? PanelMenuGroupRenderer.attributeAsString(component, "disabledClass") : "");
    }

    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.PanelMenuGroup", new Object[]{component.getClientId(context), this.getScriptObjectOptions(context, component)});
    }

    private String getExpandEvent(AbstractPanelMenuGroup group) {
        String expandEvent = group.getExpandEvent();
        if (Strings.isNullOrEmpty((String)expandEvent)) {
            expandEvent = group.getPanelMenu().getExpandEvent();
        }
        if (Strings.isNullOrEmpty((String)expandEvent)) {
            expandEvent = "click";
        }
        return expandEvent;
    }

    private String getCollapseEvent(AbstractPanelMenuGroup group) {
        String collapseEvent = group.getCollapseEvent();
        if (Strings.isNullOrEmpty((String)collapseEvent)) {
            collapseEvent = group.getPanelMenu().getCollapseEvent();
        }
        if (Strings.isNullOrEmpty((String)collapseEvent)) {
            collapseEvent = "click";
        }
        return collapseEvent;
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractPanelMenuGroup panelMenuGroup = (AbstractPanelMenuGroup)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ajax", (Object)TogglePanelRenderer.getAjaxOptions(context, (UIComponent)panelMenuGroup));
        options.put("name", panelMenuGroup.getName());
        options.put("mode", panelMenuGroup.getMode());
        options.put("disabled", PanelMenuItemRenderer.isParentPanelMenuDisabled(panelMenuGroup) || panelMenuGroup.isDisabled());
        options.put("expandEvent", this.getExpandEvent(panelMenuGroup));
        options.put("collapseEvent", this.getCollapseEvent(panelMenuGroup));
        options.put("expanded", panelMenuGroup.getState());
        options.put("selectable", panelMenuGroup.isSelectable());
        options.put("unselectable", panelMenuGroup.isUnselectable());
        options.put("stylePrefix", this.getCssClass(panelMenuGroup, ""));
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, COLLAPSE);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, EXPAND);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, SWITCH);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, BEFORE_COLLAPSE);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, BEFORE_EXPAND);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, BEFORE_SWITCH);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, BEFORE_SELECT);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuGroup, options, SELECT);
        return options;
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.encodeContentEnd(writer, context, component);
        writer.endElement("div");
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPanelMenuGroup.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        boolean isClientMode;
        AbstractPanelMenuGroup group = (AbstractPanelMenuGroup)component;
        boolean bl = isClientMode = group.getMode() == PanelMenuMode.client;
        if (isClientMode || group.getState()) {
            this.renderChildren(context, component);
        }
    }
}

