/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import org.richfaces.application.push.EventAbortedException;
import org.richfaces.application.push.SessionPreSubscriptionEvent;
import org.richfaces.application.push.SessionSubscriptionEvent;
import org.richfaces.application.push.SessionTopicListener;
import org.richfaces.application.push.SessionTopicListener2;
import org.richfaces.application.push.SessionUnsubscriptionEvent;
import org.richfaces.application.push.SubscriptionFailureException;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

final class SessionTopicListenerWrapper
implements SessionTopicListener2 {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private SessionTopicListener listener;

    public SessionTopicListenerWrapper(SessionTopicListener listener) {
        this.listener = listener;
    }

    public void processPreSubscriptionEvent(SessionPreSubscriptionEvent event) throws SubscriptionFailureException {
        try {
            this.listener.processPreSubscriptionEvent(event);
        }
        catch (EventAbortedException e) {
            throw new SubscriptionFailureException(e.getMessage());
        }
    }

    public void processSubscriptionEvent(SessionSubscriptionEvent event) {
        try {
            this.listener.processSubscriptionEvent(event);
        }
        catch (EventAbortedException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    public void processUnsubscriptionEvent(SessionUnsubscriptionEvent event) {
        try {
            this.listener.processUnsubscriptionEvent(event);
        }
        catch (EventAbortedException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    SessionTopicListener getWrappedListener() {
        return this.listener;
    }
}

