/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.richfaces.PanelMenuMode;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.AbstractPanelMenuItem;
import org.richfaces.event.ItemChangeEvent;
import org.richfaces.event.PanelToggleEvent;

public abstract class AbstractPanelMenuGroup
extends AbstractPanelMenuItem {
    public static final String COMPONENT_TYPE = "org.richfaces.PanelMenuGroup";
    public static final String COMPONENT_FAMILY = "org.richfaces.PanelMenuGroup";
    private Boolean submittedExpanded;

    protected AbstractPanelMenuGroup() {
        this.setRendererType("org.richfaces.PanelMenuGroupRenderer");
    }

    @Override
    public String getFamily() {
        return "org.richfaces.PanelMenuGroup";
    }

    public void processDecodes(FacesContext context) {
        super.processDecodes(context);
        this.executeValidate(context);
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Boolean expanded = this.getSubmittedExpanded();
        if (expanded == null) {
            return;
        }
        Boolean previous = (Boolean)this.getValue();
        this.setExpanded(expanded);
        this.setSubmittedExpanded(null);
        if (previous != null && !previous.equals(expanded)) {
            if (expanded.booleanValue() && this.getMode() == PanelMenuMode.server && this.getPanelMenu().isExpandSingle()) {
                this.collapseOtherTopGroups();
            }
            this.queueEvent((FacesEvent)new PanelToggleEvent((UIComponent)this, previous));
        }
    }

    private AbstractPanelMenuGroup getTopGroup() {
        AbstractPanelMenuGroup c = this;
        while (c.getParent() instanceof AbstractPanelMenuGroup) {
            c = (AbstractPanelMenuGroup)c.getParent();
        }
        return c;
    }

    private void collapseOtherTopGroups() {
        AbstractPanelMenuGroup topGroup = this.getTopGroup();
        for (UIComponent child : this.getPanelMenu().getChildren()) {
            AbstractPanelMenuGroup group;
            if (!(child instanceof AbstractPanelMenuGroup) || (group = (AbstractPanelMenuGroup)child) == topGroup) continue;
            group.setSubmittedExpanded(null);
            group.setExpanded(false);
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event instanceof ItemChangeEvent && event.getComponent() == this) {
            this.setEventPhase(event);
        }
        super.queueEvent(event);
    }

    protected void setEventPhase(FacesEvent event) {
        if (this.isImmediate()) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else if (this.isBypassUpdates()) {
            event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        } else {
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
    }

    public Boolean getSubmittedExpanded() {
        return this.submittedExpanded;
    }

    public void setSubmittedExpanded(Object submittedValue) {
        this.submittedExpanded = Boolean.parseBoolean(String.valueOf(submittedValue));
    }

    @Attribute
    public Boolean isExpanded() {
        return (Boolean)this.getValue();
    }

    public void setExpanded(boolean expanded) {
        this.setValue(expanded);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if ("expanded".equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), (Object)false);
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), (Object)immediate);
    }

    @Override
    @Attribute(defaultValue="Boolean.FALSE")
    public abstract Boolean isSelectable();

    @Override
    @Attribute(defaultValue="getPanelMenu().getGroupMode()")
    public abstract PanelMenuMode getMode();

    @Attribute
    public abstract String getCollapseEvent();

    @Attribute
    public abstract String getExpandEvent();

    @Attribute(generate=false)
    public String getLeftCollapsedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftCollapsedIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupCollapsedLeftIcon() : this.getPanelMenu().getGroupCollapsedLeftIcon()));
    }

    public void setLeftCollapsedIcon(String leftCollapsedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftCollapsedIcon), (Object)leftCollapsedIcon);
    }

    @Override
    @Attribute(generate=false)
    public String getLeftDisabledIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftDisabledIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupDisabledLeftIcon() : this.getPanelMenu().getGroupDisabledLeftIcon()));
    }

    @Override
    public void setLeftDisabledIcon(String leftDisabledIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftDisabledIcon), (Object)leftDisabledIcon);
    }

    @Attribute(generate=false)
    public String getLeftExpandedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftExpandedIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupExpandedLeftIcon() : this.getPanelMenu().getGroupExpandedLeftIcon()));
    }

    public void setLeftExpandedIcon(String leftExpandedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftExpandedIcon), (Object)leftExpandedIcon);
    }

    @Attribute(generate=false)
    public String getRightCollapsedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightCollapsedIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupCollapsedRightIcon() : this.getPanelMenu().getGroupCollapsedRightIcon()));
    }

    public void setRightCollapsedIcon(String rightCollapsedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightCollapsedIcon), (Object)rightCollapsedIcon);
    }

    @Override
    @Attribute(generate=false)
    public String getRightDisabledIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightDisabledIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupDisabledRightIcon() : this.getPanelMenu().getGroupDisabledRightIcon()));
    }

    @Override
    public void setRightDisabledIcon(String rightDisabledIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightDisabledIcon), (Object)rightDisabledIcon);
    }

    @Attribute(generate=false)
    public String getRightExpandedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightExpandedIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupExpandedRightIcon() : this.getPanelMenu().getGroupExpandedRightIcon()));
    }

    public void setRightExpandedIcon(String rightExpandedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightExpandedIcon), (Object)rightExpandedIcon);
    }

    @Attribute(events={@EventName(value="collapse")})
    public abstract String getOncollapse();

    @Attribute(events={@EventName(value="expand")})
    public abstract String getOnexpand();

    @Attribute(events={@EventName(value="switch")})
    public abstract String getOnswitch();

    @Attribute(events={@EventName(value="beforecollapse")})
    public abstract String getOnbeforecollapse();

    @Attribute(events={@EventName(value="beforeexpand")})
    public abstract String getOnbeforeexpand();

    @Attribute(events={@EventName(value="beforeswitch")})
    public abstract String getOnbeforeswitch();

    @Override
    @Attribute(generate=false)
    public String getDisabledClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.disabledClass), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupDisabledClass() : this.getPanelMenu().getGroupDisabledClass()));
    }

    @Override
    public void setDisabledClass(String disabledClass) {
        this.getStateHelper().put((Serializable)((Object)Properties.disabledClass), (Object)disabledClass);
    }

    @Attribute
    public abstract String getHoverClass();

    @Override
    @Attribute
    public abstract String getLeftIconClass();

    @Override
    @Attribute
    public abstract String getRightIconClass();

    @Override
    @Attribute(hidden=true)
    public abstract String getLeftIcon();

    @Override
    @Attribute(hidden=true)
    public abstract String getRightIcon();

    @Override
    @Attribute(generate=false)
    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.styleClass), (Object)(this.isTopItem() ? this.getPanelMenu().getTopGroupClass() : this.getPanelMenu().getGroupClass()));
    }

    @Override
    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)Properties.styleClass), (Object)styleClass);
    }

    @Override
    @Attribute(events={@EventName(value="beforedomupdate")})
    public abstract String getOnbeforedomupdate();

    @Override
    @Attribute(events={@EventName(value="complete")})
    public abstract String getOncomplete();

    @Override
    @Attribute(events={@EventName(value="click")})
    public abstract String getOnclick();

    @Override
    @Attribute(events={@EventName(value="dblclick")})
    public abstract String getOndblclick();

    @Override
    @Attribute(events={@EventName(value="mousedown")})
    public abstract String getOnmousedown();

    @Override
    @Attribute(events={@EventName(value="mousemove")})
    public abstract String getOnmousemove();

    @Override
    @Attribute(events={@EventName(value="mouseout")})
    public abstract String getOnmouseout();

    @Override
    @Attribute(events={@EventName(value="mouseover")})
    public abstract String getOnmouseover();

    @Override
    @Attribute(events={@EventName(value="mouseup")})
    public abstract String getOnmouseup();

    @Override
    @Attribute(events={@EventName(value="unselect")})
    public abstract String getOnunselect();

    @Override
    @Attribute(events={@EventName(value="select")})
    public abstract String getOnselect();

    @Override
    @Attribute(events={@EventName(value="beforeselect")})
    public abstract String getOnbeforeselect();

    public boolean hasActiveItem(UIComponent component, String activeItem) {
        AbstractPanelMenuGroup group;
        AbstractPanelMenuItem item;
        if (activeItem == null) {
            return false;
        }
        if (component instanceof AbstractPanelMenuItem && activeItem.equals((item = (AbstractPanelMenuItem)component).getName())) {
            return true;
        }
        if (component instanceof AbstractPanelMenuGroup && !(group = (AbstractPanelMenuGroup)component).getPanelMenu().isBubbleSelection()) {
            return false;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                if (!child.isRendered() || !(child instanceof AbstractPanelMenuItem) || !this.hasActiveItem(child, activeItem)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getState() {
        Boolean flag = this.isExpanded();
        return flag == null ? this.hasActiveItem((UIComponent)this, this.getPanelMenu().getActiveItem()) : flag.booleanValue();
    }

    static enum Properties {
        leftDisabledIcon,
        leftExpandedIcon,
        rightCollapsedIcon,
        rightDisabledIcon,
        rightExpandedIcon,
        disabledClass,
        styleClass,
        leftCollapsedIcon;

    }

    private static enum PropertyKeys {
        selectable,
        immediate;

    }
}

