/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cache.Cache;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.CachedResourceImpl;
import org.richfaces.resource.ContentProducerResource;
import org.richfaces.resource.ResourceCodec;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceFactoryImpl;
import org.richfaces.resource.ResourceRequestData;
import org.richfaces.util.RequestStateManager;
import org.richfaces.util.Util;

public class ResourceHandlerImpl
extends ResourceHandlerWrapper {
    public static final String RICHFACES_RESOURCE_IDENTIFIER = "/rfRes/";
    public static final String RESOURCE_CACHE_NAME = "org.richfaces.ResourcesCache";
    public static final String HANDLER_START_TIME_ATTRIBUTE = ResourceHandlerImpl.class.getName() + ":StartTime";
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private ResourceFactory resourceFactory;
    private ResourceHandler defaultHandler;

    public ResourceHandlerImpl(ResourceHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
        this.resourceFactory = new ResourceFactoryImpl(defaultHandler);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((CharSequence)MessageFormat.format("Instance of {0} resource handler created", ((Object)((Object)this)).getClass().getName()));
        }
    }

    public static String getResourcePathFromRequest(FacesContext context) {
        String resourceName = Util.decodeResourceURL(context);
        if (resourceName != null) {
            if (resourceName.startsWith(RICHFACES_RESOURCE_IDENTIFIER)) {
                return resourceName.substring(RICHFACES_RESOURCE_IDENTIFIER.length());
            }
            return null;
        }
        LOGGER.warn((CharSequence)("Resource key not found" + resourceName));
        return null;
    }

    protected boolean isThisHandlerResourceRequest(FacesContext context) {
        Boolean resourceRequest = RequestStateManager.BooleanRequestStateVariable.ResourceRequest.get(context);
        if (resourceRequest == null) {
            String resourcePath = ResourceHandlerImpl.getResourcePathFromRequest(context);
            resourceRequest = resourcePath != null && resourcePath.length() > 0;
            RequestStateManager.BooleanRequestStateVariable.ResourceRequest.set(context, resourceRequest);
            if (LOGGER.isDebugEnabled() && resourceRequest.booleanValue()) {
                LOGGER.debug((CharSequence)MessageFormat.format("Resource request detected: {0}", resourcePath));
            }
        }
        return resourceRequest;
    }

    public boolean isResourceRequest(FacesContext context) {
        return this.isThisHandlerResourceRequest(context) || this.defaultHandler.isResourceRequest(context);
    }

    private Resource lookupInCache(Cache cache, String resourceKey) {
        Resource resource = (Resource)cache.get((Object)resourceKey);
        if (LOGGER.isDebugEnabled()) {
            if (resource == null) {
                LOGGER.debug((CharSequence)"Resource was not located in cache");
            } else {
                LOGGER.debug((CharSequence)"Resource was located in cache");
            }
        }
        return resource;
    }

    private static void sendNotModified(FacesContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((CharSequence)"User agent has actual resource copy - sending 304 status code");
        }
        context.getExternalContext().setResponseStatus(304);
    }

    public static void sendResourceNotFound(FacesContext context) {
        context.getExternalContext().setResponseStatus(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext context) throws IOException {
        if (this.isThisHandlerResourceRequest(context)) {
            CacheableResource cacheableResource;
            ResourceCodec resourceCodec = (ResourceCodec)ServiceTracker.getService((FacesContext)context, ResourceCodec.class);
            String resourcePath = ResourceHandlerImpl.getResourcePathFromRequest(context);
            assert (resourcePath != null && resourcePath.length() != 0);
            ResourceRequestData data = resourceCodec.decodeResource(context, resourcePath);
            assert (data != null);
            Cache cache = (Cache)ServiceTracker.getService((FacesContext)context, Cache.class);
            Resource resource = this.lookupInCache(cache, data.getResourceKey());
            if (resource == null) {
                resource = this.resourceFactory.createResource(context, data);
            }
            if (resource == null) {
                ResourceHandlerImpl.sendResourceNotFound(context);
                return;
            }
            if (resource instanceof CacheableResource && (cacheableResource = (CacheableResource)resource).isCacheable(context)) {
                CachedResourceImpl cachedResource = new CachedResourceImpl();
                cachedResource.initialize(resource);
                resource = this.lookupInCache(cache, data.getResourceKey());
                if (resource == null) {
                    if (!ProjectStage.Development.equals((Object)context.getApplication().getProjectStage())) {
                        Date cacheExpirationDate = cachedResource.getExpired(context);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((CharSequence)new MessageFormat("Storing {0} resource in cache until {1,date,dd MMM yyyy HH:mm:ss zzz}", Locale.US).format(new Object[]{data.getResourceKey(), cacheExpirationDate}));
                        }
                        cache.put((Object)data.getResourceKey(), (Object)cachedResource, cacheExpirationDate);
                    }
                    resource = cachedResource;
                }
            }
            if (resource.userAgentNeedsUpdate(context)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((CharSequence)"User agent needs resource update, encoding resource");
                }
                ExternalContext externalContext = context.getExternalContext();
                Map headers = resource.getResponseHeaders();
                for (Map.Entry headerEntry : headers.entrySet()) {
                    String headerName = (String)headerEntry.getKey();
                    String headerValue = (String)headerEntry.getValue();
                    if ("content-length".equals(headerName.toLowerCase(Locale.US))) {
                        try {
                            externalContext.setResponseContentLength(Integer.parseInt(headerValue));
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    externalContext.setResponseHeader(headerName, headerValue);
                }
                String contentType = resource.getContentType();
                if (contentType != null) {
                    externalContext.setResponseContentType(contentType);
                }
                if (resource instanceof ContentProducerResource) {
                    ContentProducerResource contentProducerResource = (ContentProducerResource)resource;
                    contentProducerResource.encode(context);
                } else {
                    InputStream is = resource.getInputStream();
                    OutputStream os = externalContext.getResponseOutputStream();
                    try {
                        Util.copyStreamContent(is, os);
                    }
                    finally {
                        block31: {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    if (!LOGGER.isDebugEnabled()) break block31;
                                    LOGGER.debug((CharSequence)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((CharSequence)"Resource succesfully encoded");
                }
            } else {
                ResourceHandlerImpl.sendNotModified(context);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((CharSequence)"Passing request to the next resource handler in chain");
            }
            this.defaultHandler.handleResourceRequest(context);
        }
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource resource = this.resourceFactory.createResource(resourceName, libraryName, contentType);
        if (resource == null) {
            resource = this.defaultHandler.createResource(resourceName, libraryName, contentType);
        }
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public String getRendererTypeForResourceName(String resourceName) {
        if (resourceName.endsWith(".ecss")) {
            return "javax.faces.resource.Stylesheet";
        }
        if (resourceName.endsWith(".reslib")) {
            return "org.richfaces.renderkit.ResourceLibraryRenderer";
        }
        return this.defaultHandler.getRendererTypeForResourceName(resourceName);
    }

    public boolean libraryExists(String libraryName) {
        return this.defaultHandler.libraryExists(libraryName);
    }

    public ResourceHandler getWrapped() {
        return this.defaultHandler;
    }
}

