/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceUtils {
    private static final long MILLISECOND_IN_SECOND = 1000L;
    private static final String QUOTED_STRING_REGEX = "(?:\\\\[\\x00-\\x7F]|[^\"\\\\])+";
    private static final Pattern ETAG_PATTERN = Pattern.compile("(?:W/)?\"((?:\\\\[\\x00-\\x7F]|[^\"\\\\])+)\"(?:,\\s*)?");

    private ResourceUtils() {
    }

    public static String formatWeakTag(String eTag) {
        String formattedTag = ResourceUtils.formatTag(eTag);
        if (formattedTag == null) {
            return null;
        }
        return "W/" + formattedTag;
    }

    public static String formatTag(String eTag) {
        if (eTag == null) {
            return null;
        }
        if (!eTag.matches(QUOTED_STRING_REGEX)) {
            throw new IllegalArgumentException("tag must matches to regexp '(?:\\\\[\\x00-\\x7F]|[^\"\\\\])+'");
        }
        return '\"' + eTag + '\"';
    }

    public static boolean matchTag(String eTag, String eTagHeaderValue) {
        if (eTag == null || eTagHeaderValue == null) {
            throw new IllegalArgumentException("tag and tagHeaderValue must be not null");
        }
        Matcher eTagMatcher = ETAG_PATTERN.matcher(eTag);
        if (!eTagMatcher.find()) {
            throw new IllegalArgumentException();
        }
        String tag = eTagMatcher.group(1);
        Matcher eTagHeaderMatcher = ETAG_PATTERN.matcher(eTagHeaderValue);
        while (eTagHeaderMatcher.find()) {
            if (!tag.equals(eTagHeaderMatcher.group(1))) continue;
            return true;
        }
        return false;
    }

    public static long millisToSecond(long millisecond) {
        return millisecond / 1000L;
    }

    public static long secondToMillis(long second) {
        return second * 1000L;
    }
}

