/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.io.Serializable;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.richfaces.application.FacesMessages;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.ServiceTracker;
import org.richfaces.component.AbstractSelectComponent;
import org.richfaces.component.util.MessageUtil;

@FacesValidator(value="org.richfaces.validator.SelectLabelValueValidator")
public class SelectLabelValueValidator
implements Validator,
Serializable {
    public static final String ID = "org.richfaces.validator.SelectLabelValueValidator";
    private static final long serialVersionUID = 2343817853927262660L;

    public void validate(FacesContext facesContext, UIComponent component, Object valueAsObject) throws ValidatorException {
        String value;
        AbstractSelectComponent select = (AbstractSelectComponent)component;
        String clientId = component.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String label = (String)requestParameterMap.get(clientId + "Input");
        String string = value = valueAsObject == null ? "" : valueAsObject.toString();
        if (!this.valueWasDerivedOnClient(value, label, select)) {
            throw new ValidatorException(this.createMessage(value, label, select, facesContext));
        }
    }

    private boolean valueWasDerivedOnClient(String value, String label, AbstractSelectComponent select) {
        if (!SelectLabelValueValidator.isEmpty(value)) {
            return true;
        }
        return SelectLabelValueValidator.isEmpty(label) || label.equals(select.getDefaultLabel());
    }

    private FacesMessage createMessage(String value, String label, AbstractSelectComponent select, FacesContext facesContext) {
        String componentLabel = MessageUtil.getLabel(facesContext, (UIComponent)select);
        MessageFactory messageFactory = (MessageFactory)ServiceTracker.getService(MessageFactory.class);
        return messageFactory.createMessage(facesContext, FacesMessage.SEVERITY_ERROR, (Enum)FacesMessages.UISELECTONE_INVALID, new Object[]{componentLabel});
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

