/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator.csv;

import java.io.IOException;
import java.text.MessageFormat;
import javax.faces.application.FacesMessage;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.ScriptStringBase;

public class AddCSVMessageScript
extends ScriptStringBase
implements ScriptString {
    private static final String MESSAGE_OBJECT = "if (RichFaces.csv) '{' RichFaces.csv.addMessage('{' ''{0}'': '{'detail:''{1}'',summary:''{2}'',severity:{3}'}' '}'); '}'";
    private FacesMessage facesMessage;
    private String messageId;

    public AddCSVMessageScript(String messageId, FacesMessage facesMessage) {
        this.messageId = messageId;
        this.facesMessage = facesMessage;
    }

    public void appendScript(Appendable target) throws IOException {
        String summary = this.facesMessage.getSummary();
        String detail = this.facesMessage.getDetail();
        int severity = this.facesMessage.getSeverity().getOrdinal();
        String script = MessageFormat.format(MESSAGE_OBJECT, this.messageId, summary, detail, severity);
        target.append(script);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.facesMessage == null ? 0 : this.messageHashCode(this.facesMessage));
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AddCSVMessageScript other = (AddCSVMessageScript)((Object)obj);
        if (this.facesMessage == null ? other.facesMessage != null : !this.messagesEquals(this.facesMessage, other.facesMessage)) {
            return false;
        }
        return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
    }

    private int messageHashCode(FacesMessage message) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (message.getDetail() == null ? 0 : message.getDetail().hashCode());
        result = 31 * result + (message.getSummary() == null ? 0 : message.getSummary().hashCode());
        result = 31 * result + (message.getSeverity() == null ? 0 : message.getSeverity().getOrdinal());
        return result;
    }

    private boolean messagesEquals(FacesMessage message1, FacesMessage message2) {
        if (message1 == message2) {
            return true;
        }
        if (message1 == null && message2 != null) {
            return false;
        }
        if (message1 != null && message2 == null) {
            return false;
        }
        return this.stringEquals(message1.getSummary(), message2.getSummary()) && this.stringEquals(message1.getDetail(), message2.getDetail()) && this.severityEquals(message1.getSeverity(), message2.getSeverity());
    }

    private boolean severityEquals(FacesMessage.Severity severity1, FacesMessage.Severity severity2) {
        if (severity1 == severity2) {
            return true;
        }
        if (severity1 == null && severity2 != null) {
            return false;
        }
        if (severity1 != null && severity2 == null) {
            return false;
        }
        return severity1.getOrdinal() == severity2.getOrdinal();
    }

    private boolean stringEquals(String string1, String string2) {
        if (string1 == string2) {
            return true;
        }
        if (string1 == null && string2 != null) {
            return false;
        }
        if (string1 != null && string2 == null) {
            return false;
        }
        return string1.equals(string2);
    }
}

