/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache.lru;

import java.util.Date;
import org.richfaces.cache.Cache;
import org.richfaces.cache.lru.CacheEntry;
import org.richfaces.cache.lru.CacheMap;

public class LRUMapCache
implements Cache {
    private CacheMap map;

    public LRUMapCache() {
        this.map = new CacheMap();
    }

    public LRUMapCache(int capacity) {
        this.map = new CacheMap(capacity);
    }

    public synchronized Object get(Object key) {
        this.map.purge();
        CacheEntry entry = (CacheEntry)this.map.get(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public synchronized void put(Object key, Object value, Date expired) {
        this.map.purge();
        CacheEntry cacheEntry = new CacheEntry(key, value, expired);
        this.map.put(key, cacheEntry);
    }

    public void start() {
    }

    public void stop() {
        this.map.clear();
    }
}

