/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.UIRichMessage;

/**
 *  <p>The &lt;rich:message&gt; component renders a single FacesMessage message instance added for the component. The
 appearance of the message can be customized, and tool-tips can be used for further information about the
 message.</p>

 @author asmirnov@exadel.com

 **/
@Generated({"RichFaces CDK", "4.3.0.20121024-M2"})
public class HtmlMessage extends UIRichMessage
    implements ClientBehaviorHolder    {

    public static final String COMPONENT_TYPE="org.richfaces.HtmlMessage";

    public static final String COMPONENT_FAMILY="javax.faces.Message";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlMessage() {
        super();
        setRendererType("org.richfaces.MessageRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "keypress",
        "mousedown",
        "keyup",
        "dblclick",
        "click",
        "mouseover",
        "mousemove",
        "mouseout",
        "keydown",
        "mouseup"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }


    protected enum Properties {
        
        
    }

    

}