/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.io.IOException;
import org.ajax4jsf.javascript.ScriptStringBase;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.push.MessageData;

public class MessageDataScriptString
extends ScriptStringBase {
    private static final String TOPIC_ATTRIBUTE = ScriptUtils.toScript((Object)"topic");
    private static final String DATA_ATTRIBUTE = ScriptUtils.toScript((Object)"data");
    private static final String NUMBER_ATTRIBUTE = ScriptUtils.toScript((Object)"number");
    private final Iterable<MessageData> messages;
    private long lastMessageNumber;

    public MessageDataScriptString(Iterable<MessageData> messages) {
        this.messages = messages;
    }

    private void appendMessageToScript(MessageData message, Appendable target) throws IOException {
        target.append('<');
        target.append(TOPIC_ATTRIBUTE);
        target.append(':');
        ScriptUtils.appendScript((Appendable)target, (Object)message.getTopicKey().getTopicAddress());
        target.append(',');
        target.append(DATA_ATTRIBUTE);
        target.append(':');
        target.append(message.getSerializedMessage());
        target.append(',');
        target.append(NUMBER_ATTRIBUTE);
        target.append(':');
        ScriptUtils.appendScript((Appendable)target, (Object)message.getSequenceNumber());
        target.append('>');
    }

    public void appendScript(Appendable target) throws IOException {
        for (MessageData message : this.messages) {
            this.appendMessageToScript(message, target);
            this.lastMessageNumber = message.getSequenceNumber();
        }
    }

    public long getLastSequenceNumber() {
        return this.lastMessageNumber;
    }
}

