/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.web.filter.ExpiresRefreshPolicy;
import java.util.Date;
import org.richfaces.cache.Cache;

public class OSCacheCache
implements Cache {
    private com.opensymphony.oscache.base.Cache cache;

    public OSCacheCache(com.opensymphony.oscache.base.Cache cache) {
        this.cache = cache;
    }

    public Object get(Object key) {
        String stringKey = (String)key;
        try {
            return this.cache.getFromCache(stringKey);
        }
        catch (NeedsRefreshException e) {
            this.cache.removeEntry(stringKey);
            return null;
        }
    }

    public void put(Object key, Object value, Date expired) {
        ExpiresRefreshPolicy refreshPolicy = null;
        if (expired != null) {
            int ttl = (int)(expired.getTime() - System.currentTimeMillis()) / 1000;
            refreshPolicy = new ExpiresRefreshPolicy(ttl);
        }
        this.cache.putInCache((String)key, value, refreshPolicy);
    }

    public void start() {
    }

    public void stop() {
    }
}

