/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.resource.ResourceMappingConfiguration;

public enum ResourceLoadingOptimization {
    Packed(CoreConfiguration.Items.resourceOptimizationPackagingStages),
    Compressed(CoreConfiguration.Items.resourceOptimizationCompressionStages);

    private static final String STATIC_RESOURCES_FEATURE_NAME = "Static";
    private static final String FEATURES_PLACEHOLDER = "%Features%";
    private static final String DEFAULT_FEATURE_MAPPING_FILE = "META-INF/richfaces/staticResourceMapping/%Features%.properties";
    private CoreConfiguration.Items associatedConfiguration;

    private ResourceLoadingOptimization(CoreConfiguration.Items associatedConfiguration) {
        this.associatedConfiguration = associatedConfiguration;
    }

    static String getResourceLoadingSpecificMappingFile() {
        return ResourceLoadingOptimization.format(DEFAULT_FEATURE_MAPPING_FILE, ResourceLoadingOptimization.getEnabledFeatures());
    }

    static boolean isEnabled() {
        return ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)FacesContext.getCurrentInstance(), (Enum)CoreConfiguration.Items.resourceOptimizationEnabled);
    }

    private boolean enabled() {
        String configuredPhases = ResourceMappingConfiguration.getConfiguration(this.associatedConfiguration);
        if (configuredPhases == null) {
            return false;
        }
        ProjectStage projectStage = FacesContext.getCurrentInstance().getApplication().getProjectStage();
        return "All".equals(configuredPhases) || configuredPhases.matches("(^|.*,)" + projectStage.toString() + "($|,.*)");
    }

    private static String getEnabledFeatures() {
        StringBuffer affix = new StringBuffer();
        for (ResourceLoadingOptimization feature : ResourceLoadingOptimization.values()) {
            if (!feature.enabled()) continue;
            affix.append(feature.toString());
        }
        if (affix.length() == 0) {
            return STATIC_RESOURCES_FEATURE_NAME;
        }
        return affix.toString();
    }

    private static String format(String string, String message) {
        return string.replace(FEATURES_PLACEHOLDER, message);
    }
}

