/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.richfaces.component.util.Strings;
import org.richfaces.el.ValueDescriptor;
import org.richfaces.el.ValueExpressionAnalayser;
import org.richfaces.validator.BeanValidatorDescriptor;
import org.richfaces.validator.BeanValidatorFactory;
import org.richfaces.validator.BeanValidatorService;
import org.richfaces.validator.ValidatorDescriptor;

public class BeanValidatorServiceImpl
implements BeanValidatorService {
    private static final Collection<String> HIDDEN_PARAMS = ImmutableSet.of((Object)"message", (Object)"payload", (Object)"groups");
    private static final String FACES_CONTEXT_IS_NULL = "Faces context is null";
    private static final String INPUT_PARAMETERS_IS_NOT_CORRECT = "Input parameters is not correct.";
    private static final Class<?>[] DEFAULT_GROUP = new Class[0];
    private final ValueExpressionAnalayser analayser;
    private final BeanValidatorFactory validatorFactory;

    public BeanValidatorServiceImpl(ValueExpressionAnalayser analayser, BeanValidatorFactory validatorFactory) {
        this.analayser = analayser;
        this.validatorFactory = validatorFactory;
    }

    public Collection<ValidatorDescriptor> getConstrains(FacesContext context, ValueExpression expression, String message, Class<?> ... groups) {
        try {
            ValueDescriptor propertyDescriptor = this.analayser.getPropertyDescriptor(context, expression);
            if (propertyDescriptor == null) {
                return Collections.emptySet();
            }
            return this.processBeanAttribute(context, propertyDescriptor, message, groups);
        }
        catch (ELException e) {
            return Collections.emptySet();
        }
    }

    private Validator getValidator(FacesContext context) {
        return this.validatorFactory.getValidator(context);
    }

    Collection<ValidatorDescriptor> processBeanAttribute(FacesContext context, ValueDescriptor descriptor, String msg, Class<?> ... groups) {
        PropertyDescriptor constraintsForProperty = this.getValidator(context).getConstraintsForClass(descriptor.getBeanType()).getConstraintsForProperty(descriptor.getName());
        if (null != constraintsForProperty) {
            ElementDescriptor.ConstraintFinder propertyConstraints = constraintsForProperty.findConstraints();
            if (null != groups && groups.length > 0) {
                propertyConstraints = propertyConstraints.unorderedAndMatchingGroups((Class[])groups);
            }
            Set constraints = propertyConstraints.getConstraintDescriptors();
            FacesMessage message = Strings.isEmpty(msg) ? null : new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
            return this.processConstraints(context, constraints, message);
        }
        return Collections.emptySet();
    }

    Collection<ValidatorDescriptor> processConstraints(FacesContext context, Set<ConstraintDescriptor<?>> constraints, FacesMessage msg) {
        HashSet<ValidatorDescriptor> descriptors = new HashSet<ValidatorDescriptor>(constraints.size());
        for (ConstraintDescriptor<?> cd : constraints) {
            Annotation a = cd.getAnnotation();
            Map parameters = cd.getAttributes();
            FacesMessage message = null == msg ? this.validatorFactory.interpolateMessage(context, cd) : msg;
            Class<? extends Annotation> validatorClass = this.findAnnotationClass(a);
            BeanValidatorDescriptor beanValidatorDescriptor = new BeanValidatorDescriptor(validatorClass, message);
            for (Map.Entry entry : parameters.entrySet()) {
                String key = (String)entry.getKey();
                if (HIDDEN_PARAMS.contains(key)) continue;
                Object value = entry.getValue();
                try {
                    Method method = validatorClass.getDeclaredMethod(key, new Class[0]);
                    Object defaultValue = method.getDefaultValue();
                    if (value.equals(defaultValue)) continue;
                    beanValidatorDescriptor.addParameter(key, value);
                }
                catch (SecurityException e) {
                    beanValidatorDescriptor.addParameter(key, value);
                }
                catch (NoSuchMethodException e) {
                    beanValidatorDescriptor.addParameter(key, value);
                }
            }
            beanValidatorDescriptor.makeImmutable();
            descriptors.add(beanValidatorDescriptor);
            descriptors.addAll(this.processConstraints(context, cd.getComposingConstraints(), msg));
        }
        return descriptors;
    }

    private Class<? extends Annotation> findAnnotationClass(Annotation a) {
        Class<?> annotationClass = a.getClass();
        if (!annotationClass.isAnnotation()) {
            Class<?>[] interfaces;
            for (Class<?> implemented : interfaces = annotationClass.getInterfaces()) {
                if (!implemented.isAnnotation()) continue;
                annotationClass = implemented;
            }
        }
        return annotationClass;
    }

    public Collection<String> validateExpression(FacesContext context, ValueExpression expression, Object newValue, Class<?> ... groups) {
        if (null == context) {
            throw new FacesException(INPUT_PARAMETERS_IS_NOT_CORRECT);
        }
        Collection<String> validationMessages = null;
        if (null != expression) {
            ValueDescriptor valueDescriptor;
            try {
                valueDescriptor = this.analayser.updateValueAndGetPropertyDescriptor(context, expression, newValue);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            if (valueDescriptor != null) {
                validationMessages = this.validate(context, valueDescriptor.getBeanType(), valueDescriptor.getName(), newValue, groups);
            }
        }
        if (validationMessages == null) {
            validationMessages = Collections.emptySet();
        }
        return validationMessages;
    }

    protected Collection<String> validate(FacesContext facesContext, Class<?> beanType, String property, Object value, Class<?>[] groups) {
        Set constrains = this.getValidator(facesContext).validateValue(beanType, property, value, (Class[])this.getGroups(groups));
        return this.extractMessages(constrains);
    }

    private Class<?>[] getGroups(Class<?>[] groups) {
        return null == groups ? DEFAULT_GROUP : groups;
    }

    public Collection<String> validateObject(FacesContext context, Object value, Class<?> ... groups) {
        Set violations = this.getValidator(context).validate(value, (Class[])this.getGroups(groups));
        Collection<String> messages = this.extractMessages(violations);
        return messages;
    }

    private Collection<String> extractMessages(Set<ConstraintViolation<Object>> violations) {
        Collection<String> messages;
        if (null != violations && violations.size() > 0) {
            messages = new ArrayList(violations.size());
            for (ConstraintViolation<Object> constraintViolation : violations) {
                messages.add(constraintViolation.getMessage());
            }
        } else {
            messages = Collections.emptySet();
        }
        return messages;
    }

    protected static class ValidatorKey {
        private final Class<? extends Object> validatableClass;
        private final Locale locale;

        public ValidatorKey(Class<? extends Object> validatableClass, Locale locale) {
            this.validatableClass = validatableClass;
            this.locale = locale;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.validatableClass == null ? 0 : this.validatableClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidatorKey other = (ValidatorKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.validatableClass == null ? other.validatableClass != null : !this.validatableClass.equals(other.validatableClass));
        }
    }
}

