/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import javax.faces.context.FacesContext;
import org.richfaces.skin.AbstractSkin;
import org.richfaces.skin.Skin;

final class CompositeSkinImpl
extends AbstractSkin {
    private static final Joiner DASH_JOINER = Joiner.on((char)'-').skipNulls();
    private static final Function<Skin, String> SKIN_NAME_FUNCTION = new Function<Skin, String>(){

        public String apply(Skin from) {
            if (from == null) {
                return null;
            }
            return from.getName();
        }
    };
    private int hashCode = 0;
    private List<Skin> skinsChain;

    CompositeSkinImpl(Skin ... skinsChain) {
        this.skinsChain = Arrays.asList(skinsChain);
    }

    public boolean containsProperty(String name) {
        for (Skin skin : this.skinsChain) {
            if (skin == null || !skin.containsProperty(name)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return DASH_JOINER.join(Iterables.transform(this.skinsChain, SKIN_NAME_FUNCTION));
    }

    public int hashCode(FacesContext context) {
        int hash = this.hashCode;
        if (hash == 0) {
            for (Skin skin : this.skinsChain) {
                if (skin == null) continue;
                hash = 31 * hash + skin.hashCode(context);
            }
            this.hashCode = hash;
        }
        return hash;
    }

    void resetCachedHashCode() {
        this.hashCode = 0;
    }

    public Object getParameter(FacesContext context, String name) {
        for (Skin skin : this.skinsChain) {
            Object value;
            if (skin == null || (value = skin.getParameter(context, name)) == null) continue;
            return value;
        }
        return null;
    }

    public Object getParameter(FacesContext context, String name, Object defaultValue) {
        Object parameterValue = this.getParameter(context, name);
        if (parameterValue == null) {
            parameterValue = defaultValue;
        }
        return parameterValue;
    }
}

