/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.MenuGroupRendererBase;

@ResourceDependencies(value={@ResourceDependency(name="jsf.js", library="javax.faces", target=""), @ResourceDependency(name="jquery.js", library="", target=""), @ResourceDependency(name="richfaces.js", library="", target=""), @ResourceDependency(name="richfaces-base-component.js", library="", target=""), @ResourceDependency(name="menu-base.js", library="org.richfaces", target=""), @ResourceDependency(name="menugroup.js", library="org.richfaces", target="")})
public class MenuGroupRenderer
extends MenuGroupRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES16 = RenderKitUtils.attributes().generic("align", "align", new String[0]).generic("dir", "dir", new String[0]).generic("lang", "lang", new String[0]).generic("onclick", "onclick", "click").generic("ondblclick", "ondblclick", "dblclick").generic("onkeydown", "onkeydown", "keydown").generic("onkeypress", "onkeypress", "keypress").generic("onkeyup", "onkeyup", "keyup").generic("onmousedown", "onmousedown", "mousedown").generic("onmousemove", "onmousemove", "mousemove").generic("onmouseout", "onmouseout", "mouseout").generic("onmouseover", "onmouseover", "mouseover").generic("onmouseup", "onmouseup", "mouseup").generic("role", "role", new String[0]).generic("title", "title", new String[0]);

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent component) throws IOException {
        Object text;
        String clientId = component.getClientId(facesContext);
        Object style = component.getAttributes().get("style");
        Object cssRoot = component.getAttributes().get("cssRoot");
        Object iconClass = component.getAttributes().get("iconClass");
        Object labelClass = component.getAttributes().get("labelClass");
        String styleClass = this.getStyleClass(facesContext, component, "groupClass", "styleClass");
        String selectedClass = this.getStyleClass(facesContext, component, "selectedGroupClass", "selectedClass");
        String disabledClass = this.getStyleClass(facesContext, component, "disabledGroupClass", "disabledClass");
        boolean isDisabled = this.isDisabled(facesContext, component);
        UIComponent iconFacet = this.getIconFacet(facesContext, component);
        String iconAttribute = this.getIconAttribute(facesContext, component);
        responseWriter.startElement("div", component);
        String value = "rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-itm " + MenuGroupRenderer.convertToString(isDisabled ? "rf-" + cssRoot + "-itm-dis " + disabledClass : "rf-" + cssRoot + "-itm-unsel " + styleClass);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        if (null != (value = style) && RenderKitUtils.shouldRenderAttribute(value)) {
            responseWriter.writeAttribute("style", (Object)value, null);
        }
        RenderKitUtils.renderPassThroughAttributes(facesContext, component, PASS_THROUGH_ATTRIBUTES16);
        responseWriter.startElement("span", component);
        value = "rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-itm-ic " + MenuGroupRenderer.convertToString(iconClass);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (iconFacet != null && iconFacet.isRendered()) {
            iconFacet.encodeAll(facesContext);
        } else if (!this.isStringEmpty(iconAttribute)) {
            responseWriter.startElement("img", component);
            responseWriter.writeAttribute("alt", (Object)"", null);
            responseWriter.writeAttribute("height", (Object)"16", null);
            value = RenderKitUtils.getResourceURL(iconAttribute, facesContext);
            if (null != value && value.toString().length() > 0) {
                responseWriter.writeURIAttribute("src", (Object)value, null);
            }
            responseWriter.writeAttribute("width", (Object)"16", null);
            responseWriter.endElement("img");
        } else {
            responseWriter.startElement("span", component);
            value = "rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-emptyIcon";
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            responseWriter.endElement("span");
        }
        responseWriter.endElement("span");
        if (!isDisabled) {
            responseWriter.startElement("span", component);
            value = "rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-itm-lbl " + MenuGroupRenderer.convertToString(labelClass);
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            if ((text = component.getAttributes().get("label")) != null) {
                responseWriter.writeText(text, null);
            }
            responseWriter.endElement("span");
        } else {
            text = component.getAttributes().get("label");
            if (text != null) {
                responseWriter.writeText(text, null);
            }
        }
        responseWriter.startElement("div", component);
        value = "rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-nd";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (!isDisabled) {
            responseWriter.startElement("div", component);
            value = "rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-lst rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-sublst";
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            if (null != (value = MenuGroupRenderer.convertToString(clientId) + "_list") && value.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value, null);
            }
            if (null != (value = "display:none;min-width:" + MenuGroupRenderer.convertToString(this.getMinPopupWidth(facesContext, component)) + "px;") && value.length() > 0) {
                responseWriter.writeAttribute("style", (Object)value, null);
            }
            responseWriter.startElement("div", component);
            value = "rf-" + MenuGroupRenderer.convertToString(cssRoot) + "-lst-bg";
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            this.renderChildren(facesContext, component);
            responseWriter.endElement("div");
            responseWriter.endElement("div");
        }
        responseWriter.endElement("div");
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

