/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextWrapper;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxOutput;
import org.richfaces.context.BaseExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.context.PartialViewContextAjaxOutputTracker;

public class RenderExtendedVisitContext
extends BaseExtendedVisitContext {
    private boolean limitRender;

    public RenderExtendedVisitContext(FacesContext facesContext, Collection<String> clientIds, Set<VisitHint> hints, boolean limitRender) {
        super(facesContext, clientIds, hints, ExtendedVisitContextMode.RENDER);
        this.limitRender = limitRender;
    }

    @Override
    protected boolean hasImplicitSubtreeIdsToVisit(UIComponent component) {
        return !this.limitRender && PartialViewContextAjaxOutputTracker.hasNestedAjaxOutputs(component);
    }

    @Override
    protected void addDirectSubtreeIdsToVisitForImplicitComponents(UIComponent component, Set<String> result) {
        Collection<String> directChildrenIds;
        if (!this.limitRender && (directChildrenIds = PartialViewContextAjaxOutputTracker.getDirectChildrenIds(component)) != null && !directChildrenIds.isEmpty()) {
            result.addAll(directChildrenIds);
        }
    }

    @Override
    protected VisitResult invokeVisitCallbackForImplicitComponent(UIComponent component, VisitCallback callback) {
        AjaxOutput ajaxOutput;
        if (!this.limitRender && component instanceof AjaxOutput && (ajaxOutput = (AjaxOutput)component).isAjaxRendered()) {
            return callback.visit((VisitContext)this, component);
        }
        return VisitResult.ACCEPT;
    }

    @Override
    protected boolean shouldCompleteOnEmptyIds() {
        return this.limitRender;
    }

    public static boolean isRenderExtendedVisitContext(VisitContext visitContext) {
        if (visitContext instanceof RenderExtendedVisitContext) {
            return true;
        }
        VisitContext wrapped = visitContext;
        while (wrapped instanceof VisitContextWrapper) {
            if (!((wrapped = ((VisitContextWrapper)wrapped).getWrapped()) instanceof RenderExtendedVisitContext)) continue;
            return true;
        }
        return false;
    }
}

