/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.Map;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceLibrary;
import org.richfaces.resource.ResourceLibraryFactory;
import org.richfaces.resource.StaticResourceLibrary;
import org.richfaces.util.FastJoiner;
import org.richfaces.util.PropertiesUtil;

public class ResourceLibraryFactoryImpl
implements ResourceLibraryFactory {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final FastJoiner SLASH_JOINER = FastJoiner.on((char)'/');
    private static final Splitter COMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private Map<ResourceKey, ResourceLibrary> instances = new MapMaker().makeComputingMap((Function)new Function<ResourceKey, ResourceLibrary>(){

        public ResourceLibrary apply(ResourceKey from) {
            String propsResourceName = from.getResourceName() + ".library.properties";
            Map<String, String> props = PropertiesUtil.loadProperties("META-INF/richfaces/" + SLASH_JOINER.join(from.getLibraryName(), propsResourceName));
            String libraryClass = props.get("class");
            String resources = props.get("resources");
            if (libraryClass != null) {
                try {
                    Class<?> clazz = Class.forName(libraryClass.trim(), false, Thread.currentThread().getContextClassLoader());
                    return (ResourceLibrary)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            } else {
                if (resources != null) {
                    Iterable keys = Iterables.transform((Iterable)COMA_SPLITTER.split((CharSequence)resources), (Function)ResourceKey.FACTORY);
                    return new StaticResourceLibrary((ResourceKey[])Iterables.toArray((Iterable)keys, ResourceKey.class));
                }
                LOGGER.error((CharSequence)("'class' or 'resources' properties should be declared in library descriptor: " + from));
            }
            return null;
        }
    });

    public ResourceLibrary getResourceLibrary(String name, String library) {
        return this.instances.get(new ResourceKey(name, library));
    }
}

