/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.concurrent.atomic.AtomicReference;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.MojarraExternalResourceTracker;
import org.richfaces.resource.external.MyFacesExternalResourceTracker;

public class ExternalResourceTrackerWrapper
implements ExternalResourceTracker {
    private static final String MYFACES_RESOURCE_UTILS_CLASS = "org.apache.myfaces.shared.renderkit.html.util.ResourceUtils";
    private AtomicReference<ExternalResourceTracker> externalResourceTracker = new AtomicReference();

    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        return this.getWrapped().isResourceRenderered(facesContext, resourceKey);
    }

    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        this.getWrapped().markResourceRendered(facesContext, resourceKey);
    }

    public void markExternalResourceRendered(FacesContext facesContext, ExternalResource resource) {
        this.getWrapped().markExternalResourceRendered(facesContext, resource);
    }

    private ExternalResourceTracker getWrapped() {
        ExternalResourceTracker tracker = this.externalResourceTracker.get();
        if (tracker == null) {
            try {
                this.getClass().getClassLoader().loadClass(MYFACES_RESOURCE_UTILS_CLASS);
                this.externalResourceTracker.compareAndSet(null, new MyFacesExternalResourceTracker());
            }
            catch (Exception e) {
                this.externalResourceTracker.compareAndSet(null, new MojarraExternalResourceTracker());
            }
            tracker = this.externalResourceTracker.get();
        }
        return tracker;
    }
}

