/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.Arrays;
import java.util.Set;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.richfaces.application.ServiceTracker;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.ExternalStaticResourceFactory;

public class MyFacesExternalResourceTracker
implements ExternalResourceTracker {
    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        if (MimeType.STYLESHEET.contains(mimeType)) {
            return ResourceUtils.isRenderedStylesheet((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        }
        if (MimeType.SCRIPT.contains(mimeType)) {
            return ResourceUtils.isRenderedScript((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        }
        return false;
    }

    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        if (MimeType.STYLESHEET.contains(mimeType)) {
            ResourceUtils.markStylesheetAsRendered((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        } else if (MimeType.SCRIPT.contains(mimeType)) {
            ResourceUtils.markScriptAsRendered((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        }
    }

    public void markExternalResourceRendered(FacesContext facesContext, ExternalResource resource) {
        ExternalStaticResourceFactory externalStaticResourceFactory = (ExternalStaticResourceFactory)ServiceTracker.getService(ExternalStaticResourceFactory.class);
        ResourceKey originalResourceKey = ResourceKey.create((Resource)resource);
        Set resourcesKeys = externalStaticResourceFactory.getResourcesForLocation(resource.getExternalLocation());
        for (ResourceKey resourceKey : resourcesKeys) {
            if (originalResourceKey.equals((Object)resourceKey)) continue;
            this.markResourceRendered(facesContext, resourceKey);
        }
    }

    private static enum MimeType {
        SCRIPT("application/javascript", "text/javascript"),
        STYLESHEET("text/css");

        private String[] types;

        private MimeType(String ... types) {
            this.types = types;
        }

        public boolean contains(String type) {
            return Arrays.asList(this.types).contains(type);
        }
    }
}

