/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.ExternalStaticResourceFactory;

public class MyFacesExternalResourceTracker
implements ExternalResourceTracker {
    private final Method isRenderedStylesheet;
    private final Method isRenderedScript;
    private final Method markStylesheetAsRendered;
    private final Method markScriptAsRendered;
    private static final Logger LOG = RichfacesLogger.RESOURCE.getLogger();

    public MyFacesExternalResourceTracker(Class<?> resourceUtilsClass) {
        try {
            this.isRenderedStylesheet = resourceUtilsClass.getMethod("isRenderedStylesheet", FacesContext.class, String.class, String.class);
            this.isRenderedScript = resourceUtilsClass.getMethod("isRenderedScript", FacesContext.class, String.class, String.class);
            this.markStylesheetAsRendered = resourceUtilsClass.getMethod("markStylesheetAsRendered", FacesContext.class, String.class, String.class);
            this.markScriptAsRendered = resourceUtilsClass.getMethod("markScriptAsRendered", FacesContext.class, String.class, String.class);
        }
        catch (Exception e) {
            MyFacesExternalResourceTracker.handleException(e);
            throw new ExceptionInInitializerError(e);
        }
    }

    private static void handleException(Exception e) {
        LOG.error((CharSequence)"error while delegating resource handling to myfaces impl", (Throwable)e);
    }

    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        try {
            if (MimeType.STYLESHEET.contains(mimeType)) {
                return (Boolean)this.isRenderedStylesheet.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            }
            if (MimeType.SCRIPT.contains(mimeType)) {
                return (Boolean)this.isRenderedScript.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            }
        }
        catch (Exception e) {
            MyFacesExternalResourceTracker.handleException(e);
        }
        return false;
    }

    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        try {
            if (MimeType.STYLESHEET.contains(mimeType)) {
                this.markStylesheetAsRendered.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            } else if (MimeType.SCRIPT.contains(mimeType)) {
                this.markScriptAsRendered.invoke(null, facesContext, resourceKey.getLibraryName(), resourceKey.getResourceName());
            }
        }
        catch (Exception e) {
            MyFacesExternalResourceTracker.handleException(e);
        }
    }

    public void markExternalResourceRendered(FacesContext facesContext, ExternalResource resource) {
        ExternalStaticResourceFactory externalStaticResourceFactory = (ExternalStaticResourceFactory)ServiceTracker.getService(ExternalStaticResourceFactory.class);
        ResourceKey originalResourceKey = ResourceKey.create((Resource)resource);
        Set resourcesKeys = externalStaticResourceFactory.getResourcesForLocation(resource.getExternalLocation());
        for (ResourceKey resourceKey : resourcesKeys) {
            if (originalResourceKey.equals((Object)resourceKey)) continue;
            this.markResourceRendered(facesContext, resourceKey);
        }
    }

    private static enum MimeType {
        SCRIPT("application/javascript", "text/javascript"),
        STYLESHEET("text/css");

        private String[] types;

        private MimeType(String ... types) {
            this.types = types;
        }

        public boolean contains(String type) {
            return Arrays.asList(this.types).contains(type);
        }
    }
}

