/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.CommonComponentsConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.component.QueueRegistry;
import org.richfaces.renderkit.RenderKitUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib")})
public class QueueResourceComponentRenderer
extends Renderer {
    private static final String FUNCTION_NAME = "RichFaces.queue.setQueueOptions";

    private void appendOptions(UIComponent queue, Map<String, Object> optionsHash) {
        Map attributes = queue.getAttributes();
        for (QueueOptions option : QueueOptions.values()) {
            String optionName = option.name();
            Object value = attributes.get(optionName);
            RenderKitUtils.addToScriptHash(optionsHash, optionName, value);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        if (!ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)context, (Enum)CommonComponentsConfiguration.Items.queueEnabled).booleanValue()) {
            return;
        }
        QueueRegistry registry = QueueRegistry.getInstance(context);
        if (registry != null && registry.hasQueuesToEncode()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", component);
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)FUNCTION_NAME, null);
            writer.writeText((Object)"({", null);
            LinkedHashMap<String, Object> queueOptionsMap = new LinkedHashMap<String, Object>();
            boolean isFirst = true;
            Map<String, UIComponent> registeredQueues = registry.getRegisteredQueues();
            for (Map.Entry<String, UIComponent> queueEntry : registeredQueues.entrySet()) {
                if (!queueEntry.getValue().isRendered()) break;
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.writeText((Object)",", null);
                }
                queueOptionsMap.clear();
                String queueName = queueEntry.getKey();
                UIComponent queue = queueEntry.getValue();
                this.appendOptions(queue, queueOptionsMap);
                ScriptUtils.writeToStream((ResponseWriter)writer, (Object)queueName);
                writer.writeText((Object)":", null);
                ScriptUtils.writeToStream((ResponseWriter)writer, queueOptionsMap);
            }
            writer.writeText((Object)"});", null);
            writer.endElement("script");
        }
    }

    private static enum QueueOptions {
        onbeforedomupdate,
        oncomplete,
        onerror,
        onrequestdequeue,
        onrequestqueue,
        onsubmit,
        requestDelay,
        queueId,
        ignoreDupResponses,
        requestGroupingId;

    }
}

