/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.component.InplaceComponent;
import org.richfaces.component.attribute.StyleClassProps;
import org.richfaces.component.event.PreRenderParentListener;
import org.richfaces.renderkit.PlaceholderRendererBase;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractPlaceholder
extends UIOutput
implements StyleClassProps {
    public static final String COMPONENT_FAMILY = "org.richfaces.Placeholder";
    public static final String COMPONENT_TYPE = "org.richfaces.Placeholder";

    @Attribute(required=true)
    public abstract Object getValue();

    @Attribute
    public abstract String getSelector();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event.getSource() == this && event instanceof PostAddToViewEvent && (this.getSelector() == null || this.getSelector().isEmpty())) {
            UIComponent component = ((PostAddToViewEvent)event).getComponent();
            UIComponent parent = component.getParent();
            new PlaceholderParentPreRenderListener(parent, component);
        }
        super.processEvent(event);
    }

    private static class PlaceholderParentPreRenderListener
    extends PreRenderParentListener {
        private static final long serialVersionUID = 1870218106060075543L;

        public PlaceholderParentPreRenderListener(UIComponent parent, UIComponent component) {
            super(parent, component);
        }

        protected void preRenderParent(FacesContext facesContext, UIComponent component) {
            AbstractPlaceholder placeholder = (AbstractPlaceholder)component;
            UIComponent parent = component.getParent();
            PlaceholderRendererBase renderer = (PlaceholderRendererBase)placeholder.getRenderer(facesContext);
            if (parent instanceof InplaceComponent) {
                if (placeholder.isRendered() && placeholder.getValue() != null) {
                    ValueExpression originalExpression = parent.getValueExpression("defaultLabel");
                    if (originalExpression != null) {
                        parent.getAttributes().put("originalDefaultLabel", originalExpression);
                    } else if (((InplaceComponent)parent).getDefaultLabel() != null) {
                        parent.getAttributes().put("originalDefaultLabel", ((InplaceComponent)parent).getDefaultLabel());
                    }
                    String text = renderer.getConvertedValue(facesContext, placeholder);
                    ((InplaceComponent)parent).setDefaultLabel(text);
                } else {
                    Object defaultLabel = parent.getAttributes().get("originalDefaultLabel");
                    ((InplaceComponent)parent).setDefaultLabel(null);
                    if (defaultLabel instanceof ValueExpression) {
                        parent.setValueExpression("defaultLabel", (ValueExpression)defaultLabel);
                    } else if (defaultLabel != null) {
                        ((InplaceComponent)parent).setDefaultLabel((String)defaultLabel);
                    }
                }
            } else {
                try {
                    if (component.isRendered()) {
                        renderer.doEncodeEnd(facesContext.getResponseWriter(), facesContext, component);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Rendering of placeholder before its parent has failed", e);
                }
            }
        }
    }
}

