/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.mozilla.javascript.ErrorReporter;
import org.richfaces.log.Logger;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;
import org.richfaces.resource.optimizer.resource.writer.impl.MavenLogErrorReporter;

public class JavaScriptCompressingProcessor
implements ResourceProcessor {
    private Charset charset;
    private Logger log;

    public JavaScriptCompressingProcessor(Charset charset, Logger log) {
        this.charset = charset;
        this.log = log;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".js");
    }

    @Override
    public void process(String outputName, ByteSource byteSource, ByteSink byteSink, boolean closeAtFinish) throws IOException {
        this.process(outputName, byteSource.openStream(), byteSink.openStream(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String outputName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        Reader reader = null;
        Writer writer = null;
        try {
            reader = new InputStreamReader(in, this.charset);
            writer = new OutputStreamWriter(out, this.charset);
            MavenLogErrorReporter reporter = new MavenLogErrorReporter(outputName);
            new JavaScriptCompressor(reader, (ErrorReporter)reporter).compress(writer, 0, true, true, false, false);
            if (!closeAtFinish) {
                writer.write(";");
                writer.flush();
            }
            if (reporter.hasErrors() && this.log.isErrorEnabled()) {
                this.log.error(reporter.getErrorsLog());
            }
            if (reporter.hasWarnings() && this.log.isDebugEnabled()) {
                this.log.debug(reporter.getWarningsLog());
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
            if (closeAtFinish) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            } else {
                writer.flush();
            }
        }
    }
}

