/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final Pattern versionPattern = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+)){1}(.+)?");
    private static final String dotedVersion;
    private static final int major;
    private static final int minor;
    private static final int micro;
    private static final String version;

    public static void main(String[] args) {
        System.out.println(Version.getDotedVersion());
    }

    public static String getRawVersion() {
        return version;
    }

    public static String getDotedVersion() {
        return dotedVersion;
    }

    public static int getMajorVersion() {
        return major;
    }

    public static int getMinorVersion() {
        return minor;
    }

    public static int getMicroVersion() {
        return micro;
    }

    public static boolean equalVersion(int major, int minor) {
        return minor == Version.minor && major == Version.major;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties prop = new Properties();
        InputStream s = null;
        try {
            s = Version.class.getResourceAsStream("version.properties");
            prop.load(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ex) {}
            }
        }
        version = prop.getProperty("atmosphere.version");
        Matcher matcher = versionPattern.matcher(version);
        if (matcher.matches()) {
            dotedVersion = matcher.group(1);
            major = Integer.parseInt(matcher.group(2));
            minor = Integer.parseInt(matcher.group(3));
            micro = Integer.parseInt(matcher.group(4));
        } else {
            dotedVersion = "no.version";
            major = -1;
            minor = -1;
            micro = -1;
        }
    }
}

