/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.common;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.Graphene;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.Locations;
import org.richfaces.fragment.common.Utils;

public class Actions
extends org.openqa.selenium.interactions.Actions {
    private final WebDriver driver;

    public Actions(WebDriver driver) {
        super(driver);
        this.driver = driver;
    }

    public Actions addAction(Action a) {
        this.action.addAction(a);
        return this;
    }

    public Actions blurByJS(WebElement element) {
        return this.triggerEventByJS(Event.BLUR, element);
    }

    public Actions click(WebElement onElement) {
        super.click(onElement);
        return this;
    }

    public Actions click() {
        super.click();
        return this;
    }

    public Actions clickAndHold(WebElement onElement) {
        super.clickAndHold(onElement);
        return this;
    }

    public Actions clickAndHold() {
        super.clickAndHold();
        return this;
    }

    public Actions contextClick(WebElement onElement) {
        super.contextClick(onElement);
        return this;
    }

    public Actions contextClick() {
        super.contextClick();
        return this;
    }

    public Actions doubleClick(WebElement onElement) {
        super.doubleClick(onElement);
        return this;
    }

    public Actions doubleClick() {
        super.doubleClick();
        return this;
    }

    public Actions dragAndDrop(WebElement source, WebElement target) {
        super.dragAndDrop(source, target);
        return this;
    }

    public Actions dragAndDropBy(WebElement source, int xOffset, int yOffset) {
        super.dragAndDropBy(source, xOffset, yOffset);
        return this;
    }

    public Actions keyDown(Keys theKey) {
        super.keyDown(theKey);
        return this;
    }

    public Actions keyDown(WebElement element, Keys theKey) {
        super.keyDown(element, theKey);
        return this;
    }

    public Actions keyUp(Keys theKey) {
        super.keyUp(theKey);
        return this;
    }

    public Actions keyUp(WebElement element, Keys theKey) {
        super.keyUp(element, theKey);
        return this;
    }

    public Actions moveByOffset(int xOffset, int yOffset) {
        super.moveByOffset(xOffset, yOffset);
        return this;
    }

    public Actions moveToElement(WebElement toElement) {
        super.moveToElement(toElement);
        return this;
    }

    public Actions moveToElement(WebElement toElement, int xOffset, int yOffset) {
        super.moveToElement(toElement, xOffset, yOffset);
        return this;
    }

    public Actions release(WebElement onElement) {
        super.release(onElement);
        return this;
    }

    public Actions release() {
        super.release();
        return this;
    }

    public Actions sendKeys(CharSequence ... keysToSend) {
        super.sendKeys(keysToSend);
        return this;
    }

    public Actions sendKeys(WebElement element, CharSequence ... keysToSend) {
        super.sendKeys(element, keysToSend);
        return this;
    }

    public Actions triggerEventByJS(final Event event, final WebElement element) {
        return this.addAction(new Action(){

            public void perform() {
                Graphene.waitGui().until().element(element).is().present();
                Utils.triggerJQ((JavascriptExecutor)Actions.this.driver, event.getEventName(), element);
            }
        });
    }

    public Actions triggerEventByWD(Event event, WebElement element) {
        if (event.equals(Event.CLICK)) {
            return this.click(element);
        }
        if (event.equals(Event.DBLCLICK)) {
            return this.doubleClick(element);
        }
        if (event.equals(Event.MOUSEDOWN)) {
            return this.clickAndHold(element);
        }
        if (event.equals(Event.MOUSEMOVE)) {
            return this.moveToElement(element);
        }
        if (event.equals(Event.CONTEXTCLICK) || event.equals(Event.CONTEXTMENU)) {
            if (this.driver instanceof PhantomJSDriver) {
                final WebElement finalElem = element;
                new Actions(this.driver).moveToElement(element).build().perform();
                return this.addAction(new Action(){

                    public void perform() {
                        ArrayList<WebElement> list = new ArrayList<WebElement>();
                        list.add(finalElem);
                        ((JavascriptExecutor)Actions.this.driver).executeScript("var element = arguments[0]; \nif (window.CustomEvent) {\n    element.dispatchEvent(new CustomEvent('contextmenu'));\n} else if (document.createEvent) {\n    var ev = document.createEvent('HTMLEvents');\n    ev.initEvent('contextmenu', true, false);\n    element.dispatchEvent(ev);\n}", new Object[]{finalElem});
                    }
                });
            }
            return this.contextClick(element);
        }
        if (event.equals(Event.MOUSEOUT)) {
            Point coords = this.getPossibleCoordinationsForMouseOut(element);
            return this.moveToElement(element).moveByOffset(coords.x, coords.y);
        }
        if (event.equals(Event.MOUSEOVER)) {
            return this.moveToElement(element, 1, 1);
        }
        if (event.equals(Event.MOUSEUP)) {
            return this.clickAndHold(element).release();
        }
        throw new IllegalArgumentException("Cannot trigger this event " + event + " with WebDriver. Try to use 'triggerEventByJS' instead.");
    }

    private Point getPossibleCoordinationsForMouseOut(WebElement element) {
        Locations l = Utils.getLocations(element);
        Dimension size = this.driver.manage().window().getSize();
        int halfWidth = l.getWidth() / 2;
        int halfHeight = l.getHeight() / 2;
        int movementDistance = 10;
        Locations moved = l.moveAllBy(-movementDistance, 0);
        Point point = moved.getTopLeft();
        if (point.x > 0) {
            return new Point(-halfWidth - movementDistance, 0);
        }
        moved = l.moveAllBy(movementDistance, 0);
        point = moved.getTopRight();
        if (point.x < size.getWidth()) {
            return new Point(halfWidth + movementDistance, 0);
        }
        moved = l.moveAllBy(0, -movementDistance);
        point = moved.getTopRight();
        if (point.y > 0) {
            return new Point(0, -halfHeight - movementDistance);
        }
        moved = l.moveAllBy(0, movementDistance);
        point = moved.getBottomRight();
        if (point.y > size.getHeight()) {
            return new Point(0, halfHeight + movementDistance);
        }
        throw new RuntimeException("Cannot find any suitable position for mouseout event.");
    }

    public Actions waitAction(long timeInMillis) {
        this.action.addAction((Action)new WaitAction(timeInMillis));
        return this;
    }

    private static class WaitAction
    implements Action {
        private final long timeInMillis;

        public WaitAction(long timeInMillis) {
            this.timeInMillis = timeInMillis;
        }

        public void perform() {
            try {
                Thread.sleep(this.timeInMillis);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Actions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

