/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.panel;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.panel.Panel;

public abstract class AbstractPanel<HEADER, BODY>
implements Panel<HEADER, BODY> {
    @Root
    private WebElement root;
    private final Class<BODY> bodyClass = TypeResolver.resolveRawArguments(Panel.class, this.getClass())[1];
    private final Class<HEADER> headerClass = TypeResolver.resolveRawArguments(Panel.class, this.getClass())[0];

    public abstract AdvancedPanelInteractions advanced();

    @Override
    public BODY getBodyContent() {
        return (BODY)Graphene.createPageFragment(this.getBodyClass(), (WebElement)this.advanced().getBodyElement());
    }

    @Override
    public HEADER getHeaderContent() {
        if (!this.advanced().getHeaderElement().isPresent()) {
            throw new IllegalStateException("You are trying to get header content of the panel which does not have header!");
        }
        return (HEADER)Graphene.createPageFragment(this.getHeaderClass(), (WebElement)this.advanced().getHeaderElement());
    }

    protected Class<BODY> getBodyClass() {
        return this.bodyClass;
    }

    protected Class<HEADER> getHeaderClass() {
        return this.headerClass;
    }

    public abstract class AdvancedPanelInteractions {
        public WebElement getRootElement() {
            return AbstractPanel.this.root;
        }

        protected abstract WebElement getBodyElement();

        protected abstract GrapheneElement getHeaderElement();
    }
}

