/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebElement;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.picker.ChoicePicker;
import org.richfaces.fragment.common.picker.ChoicePickerHelper;
import org.richfaces.fragment.common.picker.MultipleChoicePicker;
import org.richfaces.fragment.list.ListComponent;
import org.richfaces.fragment.list.ListItem;

public abstract class AbstractListComponent<T extends ListItem>
implements ListComponent<T> {
    @Root
    private WebElement root;
    @FindByJQuery(value="> *")
    private List<WebElement> items;
    private final Class<T> listItemClass = TypeResolver.resolveRawArgument(ListComponent.class, this.getClass());

    @Override
    public T getItem(int index) {
        return this.getItem(ChoicePickerHelper.byIndex().index(index));
    }

    @Override
    public T getItem(String text) {
        return this.getItem(ChoicePickerHelper.byVisibleText().match(text));
    }

    @Override
    public T getItem(ChoicePicker picker) {
        return this.instantiateItemFragment(this.getListItemClass(), picker.pick(this.getItemsElements()));
    }

    @Override
    public List<T> getItems(MultipleChoicePicker picker) {
        List<WebElement> foundItems = picker.pickMultiple(this.getItemsElements());
        ArrayList result = Lists.newArrayList();
        for (WebElement foundItem : foundItems) {
            result.add(this.instantiateItemFragment(this.getListItemClass(), foundItem));
        }
        return result;
    }

    @Override
    public List<T> getItems() {
        return this.getItemsFragments();
    }

    protected List<WebElement> getItemsElements() {
        return Collections.unmodifiableList(this.items);
    }

    protected List<T> getItemsFragments() {
        return this.instantiateFragments(this.getListItemClass(), this.getItemsElements());
    }

    protected Class<T> getListItemClass() {
        return this.listItemClass;
    }

    @Override
    public WebElement getRootElement() {
        return this.root;
    }

    protected List<T> instantiateFragments(Class<T> klass, List<WebElement> itemsRoots) {
        ArrayList result = Lists.newArrayList();
        for (WebElement itemRoot : itemsRoots) {
            result.add(this.instantiateItemFragment(klass, itemRoot));
        }
        if (result.size() == 1 && !((ListItem)result.get(0)).getRootElement().isDisplayed()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(result);
    }

    protected T instantiateItemFragment(Class<T> klass, WebElement item) {
        return (T)((ListItem)Graphene.createPageFragment(klass, (WebElement)item));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.getItems().size();
    }

    public boolean isVisible() {
        return Utils.isVisible(this.getRootElement());
    }
}

