/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.richfaces.view.facelets.TagHandlerUtils;

public abstract class EventListenerHandler
extends TagHandler
implements AttachedObjectHandler {
    protected final TagAttribute binding = this.getAttribute("binding");
    protected final String listenerType;

    public EventListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        if (type != null) {
            if (type.isLiteral()) {
                try {
                    TagHandlerUtils.loadClass((String)type.getValue(), Object.class);
                }
                catch (ClassNotFoundException e) {
                    throw new TagAttributeException(type, "Couldn't qualify EventListener", (Throwable)e);
                }
            } else {
                throw new TagAttributeException(type, "Must be a literal class name of type EventListener");
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null || !ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (this.isEventSource(parent)) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            TagHandlerUtils.getOrCreateRetargetableHandlersList((UIComponent)parent).add(this);
        } else {
            throw new TagException(this.tag, "Parent does not match event source requirements: " + parent);
        }
    }

    public String getFor() {
        TagAttribute attr = this.getAttribute("for");
        return attr == null ? null : attr.getValue();
    }

    public abstract boolean isEventSource(UIComponent var1);

    public static abstract class LazyEventListener<L extends FacesListener>
    implements FacesListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final String type;
        protected final ValueExpression binding;

        protected LazyEventListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processEvent(FacesEvent event) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            FacesListener instance = null;
            if (this.binding != null) {
                instance = (FacesListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (FacesListener)TagHandlerUtils.loadClass((String)this.type, Object.class).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate EventListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                event.processListener(instance);
            }
        }
    }
}

