/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.inplaceInput;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.fragment.Root;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.Actions;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Event;
import org.richfaces.fragment.common.TextInputComponentImpl;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.inplaceInput.AbstractConfirmOrCancel;
import org.richfaces.fragment.inplaceInput.ConfirmOrCancel;
import org.richfaces.fragment.inplaceInput.InplaceComponentState;
import org.richfaces.fragment.inplaceInput.InplaceInput;

public class RichFacesInplaceInput
implements InplaceInput,
AdvancedVisibleComponentIteractions<AdvancedInplaceInputInteractions> {
    @FindBy(className="rf-ii-fld")
    private TextInputComponentImpl textInput;
    @FindByJQuery(value=".rf-ii-btn:eq(0)")
    private WebElement confirmButton;
    @FindByJQuery(value=".rf-ii-btn:eq(1)")
    private WebElement cancelButton;
    @FindBy(className="rf-ii-lbl")
    private WebElement label;
    @FindBy(css="span[id$=Edit] > input[id$=Input]")
    private WebElement editInputElement;
    @Root
    private WebElement root;
    @Drone
    private WebDriver browser;
    private final AdvancedInplaceInputInteractions advancedInteractions = new AdvancedInplaceInputInteractions();

    @Override
    public AdvancedInplaceInputInteractions advanced() {
        return this.advancedInteractions;
    }

    @Override
    public TextInputComponentImpl getTextInput() {
        return this.textInput;
    }

    @Override
    public ConfirmOrCancel type(String text) {
        this.advanced().switchToEditingState();
        if (!this.advanced().isInState(InplaceComponentState.ACTIVE)) {
            throw new IllegalStateException("You should set correct editBy event. Current: " + this.advanced().getEditByEvent() + " did not changed the inplace input for editing!");
        }
        this.getTextInput().clear().sendKeys(text);
        return new ConfirmOrCancelImpl();
    }

    public class AdvancedInplaceInputInteractions
    implements VisibleComponentInteractions {
        private static final String RF_II_CHNG_CLASS = "rf-ii-chng";
        private static final String RF_II_ACT_CLASS = "rf-ii-act";
        private final Event DEFAULT_EDIT_EVENT;
        private Event editByEvent;

        public AdvancedInplaceInputInteractions() {
            this.editByEvent = this.DEFAULT_EDIT_EVENT = Event.CLICK;
        }

        protected String getChangedClass() {
            return RF_II_CHNG_CLASS;
        }

        protected String geActiveClass() {
            return RF_II_ACT_CLASS;
        }

        protected Event getEditByEvent() {
            return this.editByEvent;
        }

        public void setEditByEvent() {
            this.editByEvent = this.DEFAULT_EDIT_EVENT;
        }

        public void setEditByEvent(Event event) {
            this.editByEvent = event;
        }

        public WebElement getRootElement() {
            return RichFacesInplaceInput.this.root;
        }

        public boolean isInState(InplaceComponentState state) {
            return this.getRootElement().getAttribute("class").contains(this.getClassForState(state));
        }

        public String getClassForState(InplaceComponentState state) {
            switch (state) {
                case ACTIVE: {
                    return this.geActiveClass();
                }
                case CHANGED: {
                    return this.getChangedClass();
                }
            }
            throw new UnsupportedOperationException();
        }

        public String getLabelValue() {
            return this.getLabelInputElement().getText().trim();
        }

        public WebElement getCancelButtonElement() {
            return RichFacesInplaceInput.this.cancelButton;
        }

        public WebElement getConfirmButtonElement() {
            return RichFacesInplaceInput.this.confirmButton;
        }

        public WebElement getEditInputElement() {
            return RichFacesInplaceInput.this.editInputElement;
        }

        public WebElement getLabelInputElement() {
            return RichFacesInplaceInput.this.label;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }

        public void switchToEditingState() {
            if (!this.isInState(InplaceComponentState.ACTIVE)) {
                new Actions(RichFacesInplaceInput.this.browser).moveToElement(this.getLabelInputElement()).triggerEventByWDOtherwiseByJS(this.getEditByEvent(), this.getLabelInputElement()).perform();
            }
        }
    }

    public class ConfirmOrCancelImpl
    extends AbstractConfirmOrCancel {
        @Override
        public WebDriver getBrowser() {
            return RichFacesInplaceInput.this.browser;
        }

        @Override
        public WebElement getConfirmButton() {
            return RichFacesInplaceInput.this.advanced().getConfirmButtonElement();
        }

        @Override
        public WebElement getInput() {
            return RichFacesInplaceInput.this.advanced().getEditInputElement();
        }

        @Override
        public WebElement getCancelButton() {
            return RichFacesInplaceInput.this.advanced().getCancelButtonElement();
        }

        @Override
        public void waitAfterConfirmOrCancel() {
        }
    }
}

