/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.fragment.popupPanel;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.richfaces.fragment.common.AdvancedVisibleComponentIteractions;
import org.richfaces.fragment.common.Locations;
import org.richfaces.fragment.common.TypeResolver;
import org.richfaces.fragment.common.Utils;
import org.richfaces.fragment.common.VisibleComponentInteractions;
import org.richfaces.fragment.common.WaitingWrapper;
import org.richfaces.fragment.common.WaitingWrapperImpl;
import org.richfaces.fragment.panel.AbstractPanel;
import org.richfaces.fragment.popupPanel.PopupPanel;

public abstract class RichFacesPopupPanel<HEADER, HEADERCONTROLS, BODY>
extends AbstractPanel<HEADER, BODY>
implements PopupPanel<HEADER, HEADERCONTROLS, BODY>,
AdvancedVisibleComponentIteractions<AdvancedPopupPanelInteractions> {
    @Drone
    private WebDriver driver;
    @FindBy(css="div.rf-pp-hndlr-t")
    private GrapheneElement resizerN;
    @FindBy(css="div.rf-pp-hndlr-r")
    private GrapheneElement resizerE;
    @FindBy(css="div.rf-pp-hndlr-b")
    private GrapheneElement resizerS;
    @FindBy(css="div.rf-pp-hndlr-l")
    private GrapheneElement resizerW;
    @FindBy(css="div.rf-pp-hndlr-tr")
    private GrapheneElement resizerNE;
    @FindBy(css="div.rf-pp-hndlr-tl")
    private GrapheneElement resizerNW;
    @FindBy(css="div.rf-pp-hndlr-br")
    private GrapheneElement resizerSE;
    @FindBy(css="div.rf-pp-hndlr-bl")
    private GrapheneElement resizerSW;
    @FindBy(css="div.rf-pp-hdr")
    private GrapheneElement headerElement;
    @FindBy(css="div.rf-pp-hdr-cnt")
    private GrapheneElement headerContentElement;
    @FindBy(css="div.rf-pp-hdr-cntrls")
    private GrapheneElement headerControlsElement;
    @FindBy(css="div.rf-pp-cnt-scrlr")
    private GrapheneElement contentScrollerElement;
    @FindBy(css="div.rf-pp-cnt")
    private GrapheneElement contentElement;
    @FindBy(css="div.rf-pp-shdw")
    private GrapheneElement shadowElement;
    private final AdvancedPopupPanelInteractions interactions = new AdvancedPopupPanelInteractions();
    private final Class<HEADERCONTROLS> headerControlsClass = TypeResolver.resolveRawArguments(RichFacesPopupPanel.class, this.getClass())[1];

    @Override
    public AdvancedPopupPanelInteractions advanced() {
        return this.interactions;
    }

    @Override
    public HEADERCONTROLS getHeaderControlsContent() {
        return (HEADERCONTROLS)Graphene.createPageFragment(this.getHeaderControlsClass(), (WebElement)this.advanced().getHeaderControlsElement());
    }

    protected Class<HEADERCONTROLS> getHeaderControlsClass() {
        return this.headerControlsClass;
    }

    public class AdvancedPopupPanelInteractions
    extends AbstractPanel.AdvancedPanelInteractions
    implements VisibleComponentInteractions {
        @Override
        protected WebElement getBodyElement() {
            return RichFacesPopupPanel.this.contentElement;
        }

        public WebElement getContentElement() {
            return this.getBodyElement();
        }

        public WebElement getContentScrollerElement() {
            return RichFacesPopupPanel.this.contentScrollerElement;
        }

        public WebElement getHeaderContentElement() {
            return RichFacesPopupPanel.this.headerContentElement;
        }

        public WebElement getHeaderControlsElement() {
            return RichFacesPopupPanel.this.headerControlsElement;
        }

        @Override
        public GrapheneElement getHeaderElement() {
            return RichFacesPopupPanel.this.headerElement;
        }

        public Locations getLocations() {
            return Utils.getLocations(this.getRootElement());
        }

        public WebElement getResizerElement(PopupPanel.ResizerLocation resizerLocation) {
            switch (resizerLocation) {
                case N: {
                    return RichFacesPopupPanel.this.resizerN;
                }
                case E: {
                    return RichFacesPopupPanel.this.resizerE;
                }
                case S: {
                    return RichFacesPopupPanel.this.resizerS;
                }
                case W: {
                    return RichFacesPopupPanel.this.resizerW;
                }
                case NE: {
                    return RichFacesPopupPanel.this.resizerNE;
                }
                case SE: {
                    return RichFacesPopupPanel.this.resizerSE;
                }
                case SW: {
                    return RichFacesPopupPanel.this.resizerSW;
                }
                case NW: {
                    return RichFacesPopupPanel.this.resizerNW;
                }
            }
            throw new UnsupportedOperationException("Unknown switch " + (Object)((Object)resizerLocation));
        }

        public WebElement getShadowElement() {
            return RichFacesPopupPanel.this.shadowElement;
        }

        @Override
        public boolean isVisible() {
            return Utils.isVisible(this.getRootElement());
        }

        public AdvancedPopupPanelInteractions moveByOffset(int xOffset, int yOffset) {
            new Actions(RichFacesPopupPanel.this.driver).dragAndDropBy((WebElement)this.getHeaderElement(), xOffset, yOffset).perform();
            return this;
        }

        public AdvancedPopupPanelInteractions resizeFromLocation(PopupPanel.ResizerLocation location, int byXPixels, int byYPixels) {
            new Actions(RichFacesPopupPanel.this.driver).dragAndDropBy(this.getResizerElement(location), byXPixels, byYPixels).perform();
            return this;
        }

        public WaitingWrapper waitUntilPopupIsNotVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    ((IsElementBuilder)wait.until().element(AdvancedPopupPanelInteractions.this.getRootElement()).is().not()).visible();
                }
            }.withMessage("Waiting for popup to be not visible.");
        }

        public WaitingWrapper waitUntilPopupIsVisible() {
            return new WaitingWrapperImpl(){

                @Override
                protected void performWait(FluentWait<WebDriver, Void> wait) {
                    wait.until().element(AdvancedPopupPanelInteractions.this.getRootElement()).is().visible();
                }
            }.withMessage("Waiting for popup to be visible.");
        }
    }
}

