/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.JBossWebSocketHandler;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossAsyncSupportWithWebSocket
extends JBossWebCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JBossAsyncSupportWithWebSocket.class);
    private final HttpEventServlet websocketHandler;

    public JBossAsyncSupportWithWebSocket(AtmosphereConfig config) {
        super(config);
        this.websocketHandler = this.newWebSocketHandler(config);
    }

    private HttpEventServlet newWebSocketHandler(AtmosphereConfig config) {
        try {
            return new JBossWebSocketHandler(config);
        }
        catch (Exception e) {
            logger.error("Cannot instantiate JBossWebSocketHandler. Websocket events will not be handled.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        boolean allowWebSocketWithoutHeaders;
        boolean bl = allowWebSocketWithoutHeaders = req.getHeader("X-Atmosphere-WebSocket-Proxy") != null;
        if (!allowWebSocketWithoutHeaders) {
            if (!JBossAsyncSupportWithWebSocket.headerContainsToken((HttpServletRequest)req, "Upgrade", "websocket")) {
                return this.doService(req, res);
            }
            if (!JBossAsyncSupportWithWebSocket.headerContainsToken((HttpServletRequest)req, "Connection", "upgrade")) {
                return this.doService(req, res);
            }
            if (!JBossAsyncSupportWithWebSocket.headerContainsToken((HttpServletRequest)req, "sec-websocket-version", "13")) {
                WebSocket.notSupported(req, res);
                return new Action(Action.TYPE.CANCELLED);
            }
        }
        try {
            Action action = this.suspended(req, res);
            if (action.type() == Action.TYPE.RESUME) {
                req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
            }
            return action;
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            return Action.CANCELLED;
        }
    }

    public Action doService(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        return super.service(req, res);
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    public void dispatch(HttpEvent httpEvent) throws IOException, ServletException {
        if (this.websocketHandler != null) {
            this.websocketHandler.event(httpEvent);
        }
    }

    private static boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }
}

