/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletProxyFactory {
    private static final Logger logger = LoggerFactory.getLogger(ServletProxyFactory.class);
    private static ServletProxyFactory factory;
    private final Map<String, MethodHandler> methods = new HashMap<String, MethodHandler>();
    private static final MethodHandler voidMethodHandler;

    private ServletProxyFactory() {
        this.addMethodHandler("encodeURL", voidMethodHandler).addMethodHandler("encodeRedirectURL", voidMethodHandler).addMethodHandler("getCharacterEncoding", new UTF8Handler()).addMethodHandler("getServerInfo", new MethodHandler(){

            @Override
            public Object handle(Object clazz, Method method, Object[] methodObjects) {
                return "Undefined";
            }
        }).addMethodHandler("getMajorVersion", new MethodHandler(){

            @Override
            public Object handle(Object clazz, Method method, Object[] methodObjects) {
                return new Integer(3);
            }
        });
    }

    public final Object proxy(Object clazz, Method method, Object[] methodObjects) {
        MethodHandler m = this.methods.get(method.getName());
        if (m != null) {
            logger.trace("Method {} handled by MethodHandler {}", (Object)method.getName(), (Object)m);
            return m.handle(clazz, method, methodObjects);
        }
        logger.trace("Method {} not supported", (Object)method.getName());
        return null;
    }

    public static ServletProxyFactory getDefault() {
        if (factory == null) {
            factory = new ServletProxyFactory();
        }
        return factory;
    }

    public ServletProxyFactory addMethodHandler(String method, MethodHandler m) {
        this.methods.put(method, m);
        return this;
    }

    static {
        voidMethodHandler = new EchoMethodHandler();
    }

    public static class UTF8Handler
    implements MethodHandler {
        @Override
        public Object handle(Object clazz, Method method, Object[] methodObjects) {
            return "UTF-8";
        }
    }

    public static class EchoMethodHandler
    implements MethodHandler {
        @Override
        public Object handle(Object clazz, Method method, Object[] methodObjects) {
            return methodObjects[0];
        }
    }

    public static interface MethodHandler {
        public Object handle(Object var1, Method var2, Object[] var3);
    }
}

